/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.snmp4j.smi.IpAddress;

public class Gui
implements ObserverObject,
ObservableObject,
ConfiguredObject {
    public final long DEFAULT_TIMEOUT = 3500L;
    public final long DEFAULT_PULSE_FREQ = 1500L;
    final String DEFAULT_MONITORING_SETTINGS_FILENAME = "core_monitoring_settings.conf";
    final String DEFAULT_GUI_SETTINGS_FILENAME = "gui_config.conf";
    final String DEFAULT_RACK_NAMES_FILENAME = "rack_names.conf";
    Socket_TCP socket;
    ArrayList<CoreSetting> settings = new ArrayList();
    MainDialog dialog;
    Journal journal;
    short[] ip = new short[4];
    String ip_str = "";
    public boolean b_gui_ready = false;
    public boolean b_full_init_info_sent = false;
    long timestamp;
    public ArrayList<IpAddress> resolved_rack_list = new ArrayList();
    public ArrayList<IpAddress> preferred_rack_list = new ArrayList();
    public ArrayList<ProflexRack> observers_racks_list = new ArrayList();
    boolean show_request_messages = true;
    boolean show_rack_structure_messages = true;
    boolean show_block_structure_messages = true;
    boolean show_block_state_messages = true;
    boolean show_add_delete_rack_messages = false;
    boolean show_alarm_messages = false;
    boolean show_pulse_messages = false;
    boolean b_first_pulse_sent = false;
    boolean b_journal_sent = false;
    Timer timer = new Timer();
    TimerTask timerTask = new MyTask();
    Timer timer_pulse = new Timer();
    TimerTask timer_pulseTask = new MyTask_Pulse();

    public Gui() {
    }

    public short[] GetIP() {
        return this.ip;
    }

    public Gui(MainDialog dialog, Socket_TCP socket_tcp, short ip1, short ip2, short ip3, short ip4, short port) {
        try {
            int i;
            this.dialog = dialog;
            this.journal = this.dialog.journal;
            this.socket = socket_tcp;
            this.b_gui_ready = false;
            this.b_first_pulse_sent = false;
            this.b_full_init_info_sent = false;
            this.ip[0] = ip1;
            this.ip[1] = ip2;
            this.ip[2] = ip3;
            this.ip[3] = ip4;
            this.ip_str = String.valueOf(this.ip[0]) + "." + String.valueOf(this.ip[1]) + "." + String.valueOf(this.ip[2]) + "." + String.valueOf(this.ip[3]);
            this.timestamp = System.currentTimeMillis();
            this.observers_racks_list.clear();
            try {
                this.settings.add(new CoreSetting("resolved_rack_list", this.DEFAULT_GUI_SETTINGS_FILENAME, this.ip_str));
                this.settings.add(new CoreSetting("port", this.DEFAULT_GUI_SETTINGS_FILENAME, this.ip_str));
                this.settings.add(new CoreSetting("gui_show_request_messages"));
                this.settings.add(new CoreSetting("gui_show_rack_structure_messages"));
                this.settings.add(new CoreSetting("gui_show_block_structure_messages"));
                this.settings.add(new CoreSetting("gui_show_block_state_messages"));
                this.settings.add(new CoreSetting("gui_show_add_delete_rack_messages"));
                this.settings.add(new CoreSetting("gui_show_alarm_messages"));
                this.settings.add(new CoreSetting("preferred_rack_list", this.DEFAULT_GUI_SETTINGS_FILENAME, this.ip_str));
                this.settings.add(new CoreSetting("gui_show_pulse_messages"));
                this.GetObjectConfig();
                this.show_request_messages = this.settings.get(2).getValue_bool();
                this.show_rack_structure_messages = this.settings.get(3).getValue_bool();
                this.show_block_structure_messages = this.settings.get(4).getValue_bool();
                this.show_block_state_messages = this.settings.get(5).getValue_bool();
                this.show_add_delete_rack_messages = this.settings.get(6).getValue_bool();
                this.show_alarm_messages = this.settings.get(7).getValue_bool();
                this.show_pulse_messages = this.settings.get(9).getValue_bool();
            }
            catch (Exception e) {
                System.out.println("Gui() -> Gui(): CoreSettings loading" + e);
                this.dialog.AddLogRecord("Gui() -> Gui(): CoreSettings loading" + e);
            }
            try {
                String ip_string = this.settings.get(0).getValue();
                String[] ip_string_list = ip_string.split(",");
                i = 0;
                for (i = 0; i < ip_string_list.length; ++i) {
                    this.resolved_rack_list.add(new IpAddress(ip_string_list[i]));
                }
            }
            catch (Exception e) {
                System.out.println("Gui() -> Gui(): resolved IP converting (" + this.settings.get(0).getValue() + ") " + e);
                this.dialog.AddLogRecord("Gui() -> Gui(): resolved IP converting (" + this.settings.get(0).getValue() + ") " + e);
            }
            try {
                String ip_string_pref = this.settings.get(8).getValue();
                String[] ip_string_list_pref = ip_string_pref.split(",");
                i = 0;
                for (i = 0; i < ip_string_list_pref.length; ++i) {
                    this.preferred_rack_list.add(new IpAddress(ip_string_list_pref[i]));
                }
            }
            catch (Exception e) {
                System.out.println("Gui() -> Gui(): preferred IP converting (" + this.settings.get(8).getValue() + ")" + e);
                this.dialog.AddLogRecord("Gui() -> Gui(): preferred IP converting (" + this.settings.get(8).getValue() + ")" + e);
            }
            String full_str = "GUI config: (IP = " + this.ip_str + ") resolved_racks:";
            for (IpAddress addr : this.resolved_rack_list) {
                full_str = full_str + addr.toString();
                full_str = full_str + ", ";
            }
            this.dialog.AddLogRecord(full_str);
            full_str = "GUI config: (IP = " + this.ip_str + ") preferred_racks: ";
            for (IpAddress addr : this.preferred_rack_list) {
                full_str = full_str + addr.toString();
                full_str = full_str + ", ";
            }
            this.dialog.AddLogRecord(full_str);
        }
        catch (Exception e) {
            System.out.println("Gui() -> Gui(): " + e);
            this.dialog.AddLogRecord("Gui() -> Gui(): " + e);
        }
    }

    public void ReloadPreferredRacks() {
        boolean n = false;
        ArrayList<IpAddress> preferred_rack_list_old = new ArrayList<IpAddress>();
        for (IpAddress ip : this.preferred_rack_list) {
            preferred_rack_list_old.add(ip);
        }
        this.preferred_rack_list.clear();
        this.settings.get(8).GetSetting();
        String ip_string = this.settings.get(8).getValue();
        String[] ip_string_list = ip_string.split(",");
        int i = 0;
        for (i = 0; i < ip_string_list.length; ++i) {
            this.preferred_rack_list.add(new IpAddress(ip_string_list[i]));
        }
        try {
            boolean b_rack_found = false;
            for (IpAddress ip_new : this.preferred_rack_list) {
                b_rack_found = false;
                for (IpAddress ip_old : preferred_rack_list_old) {
                    if (!ip_new.equals(ip_old)) continue;
                    b_rack_found = true;
                }
                if (b_rack_found) continue;
                for (ProflexRack rack : this.observers_racks_list) {
                    if (!rack.ipAddress.equals(ip_new)) continue;
                    rack.SendGui_AllRack(this);
                    this.SendGUI_UserBlocksAlarmsFiles(rack.ipAddress.toString());
                    boolean ppp = false;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Gui().ReloadPreferredRacks(): new racks searching " + e);
            this.dialog.AddLogRecord("Gui().ReloadPreferredRacks(): new racks searching " + e);
        }
        String full_str = "GUI config: (IP = " + this.ip_str + ") preferred_raks: ";
        for (IpAddress addr : this.preferred_rack_list) {
            full_str = full_str + addr.toString();
            full_str = full_str + ", ";
        }
        System.out.println(full_str);
        this.dialog.AddLogRecord(full_str);
    }

    public void ProcessGUI_Message(Message message) {
        short command_type = message.GetFromBody(1);
        int i = 0;
        String str_buffer = "Message = ";
        String client_info = " (IP = " + String.valueOf(this.ip[0]) + "." + String.valueOf(this.ip[1]) + "." + String.valueOf(this.ip[2]) + "." + String.valueOf(this.ip[3]) + ":" + String.valueOf(this.settings.get(1).getValue()) + ") ";
        switch (command_type) {
            case 10: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [GUI READY]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                this.b_gui_ready = true;
                if (!this.b_first_pulse_sent) break;
                Full_Init_Info_Thread full_init_info_thread = new Full_Init_Info_Thread();
                break;
            }
            case 20: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [rack structure request]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                break;
            }
            case 30: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [block state request]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                break;
            }
            case 40: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [block controls table request]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                break;
            }
            case 50: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [block set value request]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                short[] dest_rack_ip = new short[]{message.GetFromBody(2), message.GetFromBody(3), message.GetFromBody(4), message.GetFromBody(5)};
                for (ProflexRack rack : this.observers_racks_list) {
                    if (!Arrays.equals(rack.getIP(), dest_rack_ip)) continue;
                    short slot = message.GetFromBody(6);
                    short setting = message.GetFromBody(7);
                    short value = message.GetFromBody(8);
                    rack.SetBlockSetting(slot, setting, value);
                    break;
                }
                this.timestamp = System.currentTimeMillis();
                break;
            }
            case 60: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [send SNMP trap request]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                break;
            }
            case 70: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [write monitoring settings]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                this.ProcessNewMonitoringSetting(message);
                break;
            }
            case 120: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [new prefered racks]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                this.ProcessNewPreferredIP(message);
                this.ReloadPreferredRacks();
                this.SendGUI_PreferredRacks();
                break;
            }
            case 130: {
                String str_mess;
                if (this.show_pulse_messages) {
                    str_mess = "GUI received message from " + client_info + " Type is [NETWORK PULSE]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                if (this.b_first_pulse_sent) break;
                this.b_first_pulse_sent = true;
                str_mess = "========== GUI: FIRST PULSE SENT TO " + client_info + " ===============";
                this.dialog.AddLogRecord(str_mess);
                System.out.println(str_mess);
                Pulse_Thread pulse_thread = new Pulse_Thread();
                break;
            }
            case 140: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [get journal records]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                if (!this.b_gui_ready || !this.b_first_pulse_sent) break;
                try {
                    short year_start = message.GetFromBody(2);
                    short month_start = message.GetFromBody(3);
                    short day_start = message.GetFromBody(4);
                    short hours_start = message.GetFromBody(5);
                    short minutes_start = message.GetFromBody(6);
                    short seconds_start = message.GetFromBody(7);
                    short year_end = message.GetFromBody(8);
                    short month_end = message.GetFromBody(9);
                    short day_end = message.GetFromBody(10);
                    short hours_end = message.GetFromBody(11);
                    short minutes_end = message.GetFromBody(12);
                    short seconds_end = message.GetFromBody(13);
                    String d_start_str = String.valueOf(year_start) + "-" + String.valueOf(month_start) + "-" + String.valueOf(day_start) + " " + String.valueOf(hours_start) + ":" + String.valueOf(minutes_start) + ":" + String.valueOf(seconds_start) + ":000";
                    String d_end_str = String.valueOf(year_end) + "-" + String.valueOf(month_end) + "-" + String.valueOf(day_end) + " " + String.valueOf(hours_end) + ":" + String.valueOf(minutes_end) + ":" + String.valueOf(seconds_end) + ":000";
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                    Date d_start = sdf.parse(d_start_str);
                    Date d_end = sdf.parse(d_end_str);
                    this.journal.GetRecords(d_start, d_end, this);
                    if (!this.b_gui_ready) break;
                    Full_Init_Info_Thread full_init_info_thread = new Full_Init_Info_Thread();
                }
                catch (Exception e) {
                    System.out.println("GUI->ProcessGUI_Message(): 140 date parsing");
                    this.dialog.AddLogRecord("GUI->ProcessGUI_Message(): 140 date parsing");
                }
                break;
            }
            case 160: {
                if (this.show_request_messages) {
                    String str_mess = "GUI received message from " + client_info + " Type is [write rack name]";
                    str_buffer = "Message = ";
                    for (i = 0; i <= message.GetFromBody(0); ++i) {
                        str_buffer = str_buffer + message.GetFromBody(i);
                        str_buffer = str_buffer + "  ";
                    }
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                this.timestamp = System.currentTimeMillis();
                this.ProcessNewRackName(message);
                break;
            }
            default: {
                String str_mess = "GUI received message from " + client_info + " Type is [unknown]";
                this.dialog.AddLogRecord(str_mess);
                str_buffer = "Message = ";
                for (i = 0; i <= message.GetFromBody(0); ++i) {
                    str_buffer = str_buffer + message.GetFromBody(i);
                    str_buffer = str_buffer + "  ";
                }
                this.dialog.AddLogRecord(str_mess);
                this.dialog.AddLogRecord(str_buffer);
                System.out.println(str_mess);
                System.out.println(str_buffer);
                break;
            }
        }
    }

    @Override
    public void ProcessEvent() {
        System.out.println("GUI: some event has reached!");
        this.dialog.AddLogRecord("GUI: some event has reached!");
    }

    @Override
    public void ProcessEvent(String str) {
        System.out.println(str);
        this.dialog.AddLogRecord(str);
    }

    @Override
    public void ProcessEvent(Message message) {
        short command_type = message.GetFromBody(3);
        switch (command_type) {
            case 9: {
                this.SendGUI_RackStructure(message);
                break;
            }
            case 6: {
                this.SendGUI_BlockState(message);
                break;
            }
            case 3: {
                this.SendGUI_BlockStructure(message);
                break;
            }
        }
    }

    public void SendGUI_RackStructure(Message message) {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            short[] rack_ip = message.getIP();
            byte[] val = new byte[]{(byte)rack_ip[0], (byte)rack_ip[1], (byte)rack_ip[2], (byte)rack_ip[3]};
            IpAddress mess_ip_addr = new IpAddress(val);
            for (ProflexRack rack : this.observers_racks_list) {
                short[] list_rack_ip = rack.getIP();
                if (!Arrays.equals(rack_ip, list_rack_ip)) continue;
                for (IpAddress ip_gui_preffered : this.preferred_rack_list) {
                    if (!mess_ip_addr.equals(ip_gui_preffered)) continue;
                    Message mess = new Message();
                    mess.getClass();
                    mess.SetToHeader(2, this.ip[0]);
                    mess.getClass();
                    mess.SetToHeader(3, this.ip[1]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
                    mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(7 + rack.RACK_STRUCTURE_TABLE_SIZE));
                    mess.SetToBody(0, (short)(6 + rack.RACK_STRUCTURE_TABLE_SIZE));
                    mess.SetToBody(1, (short)20);
                    mess.SetToBody(2, rack_ip[0]);
                    mess.SetToBody(3, rack_ip[1]);
                    mess.SetToBody(4, rack_ip[2]);
                    mess.SetToBody(5, rack_ip[3]);
                    if (message.GetFromBody(4) == 0) {
                        mess.SetToBody(6, (short)0);
                    } else {
                        mess.SetToBody(6, rack.RACK_STRUCTURE_TABLE_SIZE);
                        int i = 0;
                        for (i = 0; i < rack.RACK_STRUCTURE_TABLE_SIZE; ++i) {
                            mess.SetToBody(7 + i, rack.rackStructureTable[i]);
                        }
                    }
                    if (message.GetFromBody(4) == 0) {
                        this.observers_racks_list.remove(rack);
                        if (this.show_add_delete_rack_messages) {
                            String str_full = "";
                            String list_rack_ip_str = String.valueOf(list_rack_ip[0]) + "." + String.valueOf(list_rack_ip[1]) + "." + String.valueOf(list_rack_ip[2]) + "." + String.valueOf(list_rack_ip[3]);
                            str_full = "Gui -> SendGUI_RackStructure(): (gui_ip = " + this.ip_str + "),  removing rack: (rack = " + list_rack_ip_str + ") rack_list =  ";
                            for (ProflexRack rack_list : this.observers_racks_list) {
                                short[] list_rack_new_ip_short = rack_list.getIP();
                                list_rack_ip_str = String.valueOf(list_rack_new_ip_short[0]) + "." + String.valueOf(list_rack_new_ip_short[1]) + "." + String.valueOf(list_rack_new_ip_short[2]) + "." + String.valueOf(list_rack_new_ip_short[3]);
                                str_full = str_full + list_rack_ip_str + ", ";
                            }
                            System.out.println(str_full);
                            this.dialog.AddLogRecord(str_full);
                        }
                    }
                    if (this.show_rack_structure_messages) {
                        System.out.println("GUI -> SendGUI_RackStructure(): (gui_ip = " + this.ip_str + "), message = " + mess.toString());
                        this.dialog.AddLogRecord("GUI -> SendGUI_RackStructure(): (gui_ip = " + this.ip_str + "),message = " + mess.toString());
                    }
                    this.socket.Write(mess);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI -> SendGUI_RackStructure(): " + e);
            this.dialog.AddLogRecord("GUI -> SendGUI_RackStructure(): " + e);
        }
    }

    public void SendGUI_BlockStructure(Message message) {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            short[] rack_ip = message.getIP();
            byte[] val = new byte[]{(byte)rack_ip[0], (byte)rack_ip[1], (byte)rack_ip[2], (byte)rack_ip[3]};
            IpAddress mess_ip_addr = new IpAddress(val);
            for (ProflexRack rack : this.observers_racks_list) {
                short[] list_rack_ip = rack.getIP();
                if (!Arrays.equals(rack_ip, list_rack_ip)) continue;
                for (IpAddress ip_gui_preffered : this.preferred_rack_list) {
                    if (!mess_ip_addr.equals(ip_gui_preffered)) continue;
                    Message mess = new Message();
                    mess.getClass();
                    mess.SetToHeader(2, this.ip[0]);
                    mess.getClass();
                    mess.SetToHeader(3, this.ip[1]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
                    mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(8 + message.GetFromBody(4)));
                    mess.SetToBody(0, (short)(7 + message.GetFromBody(4)));
                    mess.SetToBody(1, (short)40);
                    mess.SetToBody(2, rack_ip[0]);
                    mess.SetToBody(3, rack_ip[1]);
                    mess.SetToBody(4, rack_ip[2]);
                    mess.SetToBody(5, rack_ip[3]);
                    mess.SetToBody(6, message.GetFromBody(1));
                    mess.SetToBody(7, message.GetFromBody(4));
                    int i = 0;
                    for (i = 0; i < message.GetFromBody(4); ++i) {
                        mess.SetToBody(8 + i, message.GetFromBody(5 + i));
                    }
                    if (this.show_block_structure_messages) {
                        System.out.println("GUI -> SendGUI_BlockStructure():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                        this.dialog.AddLogRecord("GUI -> SendGUI_BlockStructure():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                    }
                    this.socket.Write(mess);
                    String ip_str = rack_ip[0] + "." + rack_ip[1] + "." + rack_ip[2] + "." + rack_ip[3];
                    this.SendGUI_UserBlocksAlarmsFiles(ip_str, message.GetFromBody(1));
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI -> SendGUI_BlockStructure(): " + e);
            this.dialog.AddLogRecord("GUI -> SendGUI_BlockStructure(): " + e);
        }
    }

    public void SendGUI_Alarm(Message message) {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)17);
            if (this.show_alarm_messages) {
                System.out.println("GUI.SendGUI_Alarm():  (gui_ip = " + this.ip_str + "),  message = " + message.toString());
                this.dialog.AddLogRecord("GUI.SendGUI_Alarm(): (gui_ip = " + this.ip_str + "),  message = " + message.toString());
            }
            this.socket.Write(message);
            boolean ppp = false;
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_Alarm(): " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_Alarm(): " + e);
        }
    }

    public void SendGUI_Pulse() {
        if (!this.b_gui_ready) {
            return;
        }
        try {
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)2);
            message.SetToBody(0, (short)1);
            message.SetToBody(1, (short)130);
            if (this.show_pulse_messages) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss:SSS");
                Date date = new Date();
                String date_str = sdf.format(date);
                System.out.println("========== GUI.SendGUI_Pulse(): GUI = [ " + this.ip_str + " ] ===== ( " + date_str + " ) ======================================= ");
                this.dialog.AddLogRecord("========== GUI.SendGUI_Pulse(): GUI = [ " + this.ip_str + " ] ===== ( " + date_str + " ) =======================================");
            }
            this.timestamp = System.currentTimeMillis();
            this.socket.Write(message);
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_Alarm(): " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_Alarm(): " + e);
        }
    }

    public void SendGUI_ResolvedRacks() {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            short[] list_rack_ip = new short[4];
            byte[] list_rack_ip_b = new byte[4];
            int rack_count = 0;
            int i = 0;
            Message mess = new Message();
            mess.getClass();
            mess.SetToHeader(2, this.ip[0]);
            mess.getClass();
            mess.SetToHeader(3, this.ip[1]);
            mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
            mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
            mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)2);
            mess.SetToBody(0, (short)1);
            mess.SetToBody(1, (short)110);
            mess.SetToBody(2, (short)0);
            for (IpAddress ip : this.resolved_rack_list) {
                ++rack_count;
                list_rack_ip_b = ip.toByteArray();
                for (i = 0; i < 4; ++i) {
                    list_rack_ip[i] = (short)(list_rack_ip_b[i] & 0xFF);
                }
                mess.getClass();
                mess.SetToHeader(2, this.ip[0]);
                mess.getClass();
                mess.SetToHeader(3, this.ip[1]);
                mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
                mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
                mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(rack_count * 4 + 3));
                mess.SetToBody(0, (short)(rack_count * 4 + 2));
                mess.SetToBody(1, (short)110);
                mess.SetToBody(2, (short)rack_count);
                for (i = 0; i < 4; ++i) {
                    mess.SetToBody(3 + (rack_count - 1) * 4 + i, list_rack_ip[i]);
                }
            }
            if (rack_count > 0) {
                this.socket.Write(mess);
                if (this.show_block_structure_messages) {
                    System.out.println("GUI.SendGUI_ResolvedRacks():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                    this.dialog.AddLogRecord("GUI.SendGUI_ResolvedRacks():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_ResolvedRacks(): " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_ResolvedRacks(): " + e);
        }
    }

    public void SendGUI_PreferredRacks() {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            short[] list_rack_ip = new short[4];
            byte[] list_rack_ip_b = new byte[4];
            int rack_count = 0;
            int i = 0;
            Message mess = new Message();
            mess.getClass();
            mess.SetToHeader(2, this.ip[0]);
            mess.getClass();
            mess.SetToHeader(3, this.ip[1]);
            mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
            mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
            mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)2);
            mess.SetToBody(0, (short)1);
            mess.SetToBody(1, (short)120);
            mess.SetToBody(2, (short)0);
            for (IpAddress ip : this.preferred_rack_list) {
                ++rack_count;
                list_rack_ip_b = ip.toByteArray();
                for (i = 0; i < 4; ++i) {
                    list_rack_ip[i] = (short)(list_rack_ip_b[i] & 0xFF);
                }
                mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(rack_count * 4 + 3));
                mess.SetToBody(0, (short)(rack_count * 4 + 2));
                mess.SetToBody(1, (short)120);
                mess.SetToBody(2, (short)rack_count);
                for (i = 0; i < 4; ++i) {
                    mess.SetToBody(3 + (rack_count - 1) * 4 + i, list_rack_ip[i]);
                }
            }
            if (rack_count > 0) {
                this.socket.Write(mess);
                if (this.show_block_structure_messages) {
                    System.out.println("GUI.SendGUI_PreferredRacks():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                    this.dialog.AddLogRecord("GUI.SendGUI_PreferredRacks():  (gui_ip = " + this.ip_str + "),  message = " + mess.toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_PreferredRacks(): " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_PreferredRacks(): " + e);
        }
    }

    public void SendGUI_DefaultBlocksAlarmsFiles() {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        File folder = new File("DEFAULT_BLOCKS_ALARMS");
        File[] listOfFiles = folder.listFiles();
        for (File fileEntry : folder.listFiles()) {
            if (!fileEntry.isDirectory()) continue;
        }
        int i = 0;
        int j = 0;
        int files_count = listOfFiles.length;
        try {
            String full_string = "";
            Message mess = new Message();
            mess.getClass();
            mess.SetToHeader(2, this.ip[0]);
            mess.getClass();
            mess.SetToHeader(3, this.ip[1]);
            mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
            mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
            mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)0);
            mess.SetToBody(0, (short)0);
            mess.SetToBody(1, (short)100);
            mess.SetToBody(2, (short)1);
            for (i = 0; i < listOfFiles.length; ++i) {
                String s;
                FileInputStream fis = new FileInputStream(listOfFiles[i].getPath());
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "Cp1251"));
                int filemane_length = listOfFiles[i].getName().length();
                String str_file = "";
                int str_file_length = 0;
                while ((s = br.readLine()) != null && s.length() > 0) {
                    str_file = str_file + s;
                    str_file = str_file + ";";
                }
                fis.close();
                int message_last_index = 3;
                int total_length = 2;
                str_file_length = str_file.length();
                mess.SetToBody(message_last_index, (short)filemane_length);
                ++message_last_index;
                ++total_length;
                for (j = 0; j < filemane_length; ++j) {
                    mess.SetToBody(message_last_index + j, (short)listOfFiles[i].getName().charAt(j));
                }
                message_last_index = message_last_index + filemane_length + 1;
                total_length = total_length + filemane_length + 1;
                mess.SetToBody(message_last_index, (short)str_file_length);
                ++message_last_index;
                ++total_length;
                for (j = 0; j < str_file_length; ++j) {
                    mess.SetToBody(message_last_index + j, (short)str_file.charAt(j));
                }
                message_last_index = message_last_index + str_file_length + 1;
                total_length = total_length + str_file_length + 1;
                mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(total_length + 1));
                mess.SetToBody(0, (short)total_length);
                this.socket.Write(mess);
                String str_full = "GUI: SendGUI_DefaultBlocksAlarmsFiles():  (gui_ip = " + this.ip_str + "),  sent file [" + i + "], " + "  message = " + mess.toString();
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_DefaultBlocksAlarmsFiles(): " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_DefaultBlocksAlarmsFiles(): " + e);
        }
    }

    public synchronized void SendGUI_UserBlocksAlarmsFiles() {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)0);
            message.SetToBody(1, (short)80);
            int message_length = 2;
            int message_blocks_count = 0;
            try {
                String s;
                FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s_block = "";
                String file_ip = "";
                int[] file_ip_int = new int[4];
                boolean b_preferred_found = false;
                block4: while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    int i;
                    if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                        s = s.replaceAll(" ", "");
                        file_ip = s.substring(1, s.length() - 1);
                        String[] file_ip_splitted = file_ip.split("\\.");
                        for (i = 0; i < 4; ++i) {
                            file_ip_int[i] = Integer.parseInt(file_ip_splitted[i]);
                        }
                        b_preferred_found = false;
                        for (IpAddress preferred_ip : this.preferred_rack_list) {
                            IpAddress block_ip;
                            if (!preferred_ip.equals(block_ip = new IpAddress(file_ip))) continue;
                            b_preferred_found = true;
                            continue block4;
                        }
                        continue;
                    }
                    if (b_preferred_found) {
                        s = s.replaceAll(" ", "");
                        String[] splitted = s.split(";");
                        int[] table = new int[10];
                        for (i = 0; i < 10; ++i) {
                            table[i] = Integer.parseInt(splitted[i]);
                            if (splitted[i] != "0") continue;
                            table[i] = 0;
                        }
                        int file_slot = table[0];
                        long file_code = table[9];
                        boolean b_code_match = false;
                        for (ProflexRack rack : this.observers_racks_list) {
                            String rack_ip = rack.ipAddress_str;
                            if (!rack_ip.equals(file_ip)) continue;
                            for (ProflexCard card : rack.cards_list) {
                                if (card.slot != file_slot) continue;
                                if (file_code == (long)card.code) {
                                    b_code_match = true;
                                    continue;
                                }
                                b_code_match = false;
                            }
                        }
                        if (b_code_match) {
                            short[] b = new short[]{(short)(table[9] >> 24), (short)(table[9] >> 16 & 0xFF), (short)(table[9] >> 8 & 0xFF), (short)(table[9] & 0xFF)};
                            message.SetToBody(message_length + 1, (short)file_ip_int[0]);
                            message.SetToBody(message_length + 2, (short)file_ip_int[1]);
                            message.SetToBody(message_length + 3, (short)file_ip_int[2]);
                            message.SetToBody(message_length + 4, (short)file_ip_int[3]);
                            message.SetToBody(message_length + 5, (short)table[0]);
                            message.SetToBody(message_length + 6, (short)table[1]);
                            message.SetToBody(message_length + 7, (short)table[2]);
                            message.SetToBody(message_length + 8, (short)table[3]);
                            message.SetToBody(message_length + 9, (short)table[4]);
                            message.SetToBody(message_length + 10, (short)table[5]);
                            message.SetToBody(message_length + 11, (short)table[6]);
                            message.SetToBody(message_length + 12, (short)table[7]);
                            message.SetToBody(message_length + 13, (short)table[8]);
                            message.SetToBody(message_length + 14, b[0]);
                            message.SetToBody(message_length + 15, b[1]);
                            message.SetToBody(message_length + 16, b[2]);
                            message.SetToBody(message_length + 17, b[3]);
                            message_length += 17;
                            ++message_blocks_count;
                        }
                    }
                    message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(message_length + 1));
                    message.SetToBody(0, (short)message_length);
                    message.SetToBody(2, (short)message_blocks_count);
                }
                fileReader.close();
                this.socket.Write(message);
                System.out.println("GUI.SendGUI_UserBlocksAlarmsFiles():  (gui_ip = " + this.ip_str + "),  " + message.toString());
                this.dialog.AddLogRecord("GUI.SendGUI_UserBlocksAlarmsFiles():  (gui_ip = " + this.ip_str + "),  " + message.toString());
            }
            catch (Exception e) {
                System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(): file read error " + e);
                this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(): file read error " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(): racks " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(): racks " + e);
        }
    }

    public synchronized void SendGUI_UserBlocksAlarmsFiles(String ip_str) {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)0);
            message.SetToBody(1, (short)80);
            int message_length = 2;
            int message_blocks_count = 0;
            try {
                String s;
                FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s_block = "";
                String file_ip = "";
                int[] file_ip_int = new int[4];
                boolean b_ip_found = false;
                boolean b_preferred_found = false;
                block4: while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    int i;
                    if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                        file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1);
                        b_ip_found = file_ip.equals(ip_str);
                        String[] file_ip_splitted = file_ip.split("\\.");
                        for (i = 0; i < 4; ++i) {
                            file_ip_int[i] = Integer.parseInt(file_ip_splitted[i]);
                        }
                        b_preferred_found = false;
                        for (IpAddress preferred_ip : this.preferred_rack_list) {
                            IpAddress block_ip;
                            if (!preferred_ip.equals(block_ip = new IpAddress(file_ip))) continue;
                            b_preferred_found = true;
                            continue block4;
                        }
                        continue;
                    }
                    if (!b_preferred_found || !b_ip_found) continue;
                    s = s.replaceAll(" ", "");
                    String[] splitted = s.split(";");
                    int[] table = new int[10];
                    for (i = 0; i < 10; ++i) {
                        table[i] = Integer.parseInt(splitted[i]);
                        if (splitted[i] != "0") continue;
                        table[i] = 0;
                    }
                    int file_slot = table[0];
                    long file_code = table[9];
                    boolean b_code_match = false;
                    for (ProflexRack rack : this.observers_racks_list) {
                        String rack_ip = rack.ipAddress_str;
                        if (!rack_ip.equals(file_ip)) continue;
                        for (ProflexCard card : rack.cards_list) {
                            if (card.slot != file_slot) continue;
                            if (file_code == (long)card.code) {
                                b_code_match = true;
                                continue;
                            }
                            b_code_match = false;
                        }
                    }
                    if (!b_code_match) continue;
                    short[] b = new short[]{(short)(table[9] >> 24), (short)(table[9] >> 16 & 0xFF), (short)(table[9] >> 8 & 0xFF), (short)(table[9] & 0xFF)};
                    message.SetToBody(message_length + 1, (short)file_ip_int[0]);
                    message.SetToBody(message_length + 2, (short)file_ip_int[1]);
                    message.SetToBody(message_length + 3, (short)file_ip_int[2]);
                    message.SetToBody(message_length + 4, (short)file_ip_int[3]);
                    message.SetToBody(message_length + 5, (short)table[0]);
                    message.SetToBody(message_length + 6, (short)table[1]);
                    message.SetToBody(message_length + 7, (short)table[2]);
                    message.SetToBody(message_length + 8, (short)table[3]);
                    message.SetToBody(message_length + 9, (short)table[4]);
                    message.SetToBody(message_length + 10, (short)table[5]);
                    message.SetToBody(message_length + 11, (short)table[6]);
                    message.SetToBody(message_length + 12, (short)table[7]);
                    message.SetToBody(message_length + 13, (short)table[8]);
                    message.SetToBody(message_length + 14, b[0]);
                    message.SetToBody(message_length + 15, b[1]);
                    message.SetToBody(message_length + 16, b[2]);
                    message.SetToBody(message_length + 17, b[3]);
                    message.SetToHeader(message.POS_SIZE_OF_DATA, (short)((message_length += 17) + 1));
                    message.SetToBody(0, (short)message_length);
                    message.SetToBody(2, (short)(++message_blocks_count));
                }
                fileReader.close();
                this.socket.Write(message);
                System.out.println("GUI.SendGUI_UserBlocksAlarmsFiles(ip):  (gui_ip = " + this.ip_str + "),  " + message.toString());
                this.dialog.AddLogRecord("GUI.SendGUI_UserBlocksAlarmsFiles(ip):  (gui_ip = " + this.ip_str + "),  " + message.toString());
            }
            catch (Exception e) {
                System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(ip): file read error " + e);
                this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(ip): file read error " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(ip): racks " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(ip): racks " + e);
        }
    }

    public synchronized void SendGUI_UserBlocksAlarmsFiles(String ip_str, int slot) {
        if (!this.b_gui_ready || !this.b_first_pulse_sent) {
            return;
        }
        try {
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)0);
            message.SetToBody(1, (short)80);
            int message_length = 2;
            int message_blocks_count = 0;
            try {
                String s;
                FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s_block = "";
                String file_ip = "";
                int[] file_ip_int = new int[4];
                boolean b_ip_found = false;
                boolean b_preferred_found = false;
                block4: while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    int i;
                    if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                        file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1);
                        b_ip_found = file_ip.equals(ip_str);
                        String[] file_ip_splitted = file_ip.split("\\.");
                        for (i = 0; i < 4; ++i) {
                            file_ip_int[i] = Integer.parseInt(file_ip_splitted[i]);
                        }
                        b_preferred_found = false;
                        for (IpAddress preferred_ip : this.preferred_rack_list) {
                            IpAddress block_ip;
                            if (!preferred_ip.equals(block_ip = new IpAddress(file_ip))) continue;
                            b_preferred_found = true;
                            continue block4;
                        }
                        continue;
                    }
                    if (!b_preferred_found || !b_ip_found) continue;
                    s = s.replaceAll(" ", "");
                    String[] splitted = s.split(";");
                    int[] table = new int[10];
                    for (i = 0; i < 10; ++i) {
                        table[i] = Integer.parseInt(splitted[i]);
                        if (splitted[i] != "0") continue;
                        table[i] = 0;
                    }
                    int file_slot = table[0];
                    long file_code = table[9];
                    boolean b_code_match = false;
                    for (ProflexRack rack : this.observers_racks_list) {
                        String rack_ip = rack.ipAddress_str;
                        if (!rack_ip.equals(file_ip)) continue;
                        for (ProflexCard card : rack.cards_list) {
                            if (card.slot != file_slot) continue;
                            if (file_code == (long)card.code) {
                                b_code_match = true;
                                continue;
                            }
                            b_code_match = false;
                        }
                    }
                    if (!b_code_match || table[0] != slot) continue;
                    short[] b = new short[]{(short)(table[9] >> 24), (short)(table[9] >> 16 & 0xFF), (short)(table[9] >> 8 & 0xFF), (short)(table[9] & 0xFF)};
                    message.SetToBody(3, (short)file_ip_int[0]);
                    message.SetToBody(4, (short)file_ip_int[1]);
                    message.SetToBody(5, (short)file_ip_int[2]);
                    message.SetToBody(6, (short)file_ip_int[3]);
                    message.SetToBody(7, (short)table[0]);
                    message.SetToBody(8, (short)table[1]);
                    message.SetToBody(9, (short)table[2]);
                    message.SetToBody(10, (short)table[3]);
                    message.SetToBody(11, (short)table[4]);
                    message.SetToBody(12, (short)table[5]);
                    message.SetToBody(13, (short)table[6]);
                    message.SetToBody(14, (short)table[7]);
                    message.SetToBody(15, (short)table[8]);
                    message.SetToBody(16, b[0]);
                    message.SetToBody(17, b[1]);
                    message.SetToBody(18, b[2]);
                    message.SetToBody(19, b[3]);
                    message_length += 17;
                    ++message_blocks_count;
                    message.SetToHeader(message.POS_SIZE_OF_DATA, (short)20);
                    message.SetToBody(0, (short)19);
                    message.SetToBody(2, (short)1);
                    this.socket.Write(message);
                    System.out.println("GUI.SendGUI_UserBlocksAlarmsFiles(ip, slot):  (gui_ip = " + this.ip_str + "),  " + message.toString());
                    this.dialog.AddLogRecord("GUI.SendGUI_UserBlocksAlarmsFiles(ip, slot):  (gui_ip = " + this.ip_str + "),  " + message.toString());
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(ip, slot): file read error " + e);
                this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(ip, slot): file read error " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI: SendGUI_UserBlocksAlarmsFiles(ip, slot): racks " + e);
            this.dialog.AddLogRecord("GUI: SendGUI_UserBlocksAlarmsFiles(ip, slot): racks " + e);
        }
    }

    public synchronized void SendGUI_BlockState(Message message) {
        block19: {
            if (!this.b_gui_ready || !this.b_first_pulse_sent) {
                return;
            }
            try {
                short[] rack_ip = message.getIP();
                byte[] val = new byte[]{(byte)rack_ip[0], (byte)rack_ip[1], (byte)rack_ip[2], (byte)rack_ip[3]};
                IpAddress mess_ip_addr = new IpAddress(val);
                if (this.observers_racks_list.size() <= 0) break block19;
                for (ProflexRack rack : this.observers_racks_list) {
                    short[] list_rack_ip = rack.getIP();
                    if (!Arrays.equals(rack_ip, list_rack_ip)) continue;
                    for (IpAddress ip_gui_preffered : this.preferred_rack_list) {
                        if (!mess_ip_addr.equals(ip_gui_preffered)) continue;
                        Message mess = new Message();
                        int i = 0;
                        short sh_hi = 0;
                        short sh_lo = 0;
                        short table_length_old = message.GetFromBody(4);
                        int table_length_new = (table_length_old - 1) / 2 + 1;
                        if (table_length_old > 0) {
                            short[] status_hi_lo_array_old = new short[table_length_old];
                            short[] status_hi_lo_array_new = new short[table_length_new];
                            status_hi_lo_array_old[0] = message.GetFromBody(8 + table_length_old);
                            try {
                                for (i = 0; i < table_length_old - 1; ++i) {
                                    status_hi_lo_array_old[i + 1] = message.GetFromBody(9 + i);
                                }
                            }
                            catch (Exception e) {
                                System.out.println("GUI: SendGUI_BlockState(): (lo,hi,lo,hi) i = " + i + ", max_element = " + i + 1 + ", arr_size = " + table_length_old + ", Exception = " + e);
                                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): (lo,hi,lo,hi) i = " + i + ", max_element = " + i + 1 + ", arr_size = " + table_length_old + ", Exception = " + e);
                            }
                            try {
                                short element_hi = 0;
                                short element_lo = 0;
                                for (i = 1; i < table_length_old - 1; i += 2) {
                                    element_hi = status_hi_lo_array_old[i + 1];
                                    element_lo = status_hi_lo_array_old[i];
                                    status_hi_lo_array_old[i] = element_hi;
                                    status_hi_lo_array_old[i + 1] = element_lo;
                                }
                            }
                            catch (Exception e) {
                                System.out.println("GUI: SendGUI_BlockState(): (hi,lo,hi,lo) i = " + i + ", max_element = " + i + 1 + ", arr_size = " + table_length_old + ", Exception = " + e);
                                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): (hi,lo,hi,lo) i = " + i + ", max_element = " + i + 1 + ", arr_size = " + table_length_old + ", Exception = " + e);
                            }
                            try {
                                status_hi_lo_array_new[0] = status_hi_lo_array_old[0];
                                for (i = 1; i < table_length_new; ++i) {
                                    sh_hi = (short)(status_hi_lo_array_old[i * 2 - 1] << 8);
                                    sh_lo = status_hi_lo_array_old[i * 2];
                                    status_hi_lo_array_new[i] = (short)(sh_hi | sh_lo);
                                }
                            }
                            catch (Exception e) {
                                System.out.println("GUI: SendGUI_BlockState(): (merge) i = " + i + ", max_element = " + i * 2 + ", arr_size = " + table_length_old + ", Exception = " + e);
                                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): (merge) i = " + i + ", max_element = " + i * 2 + ", arr_size = " + table_length_old + ", Exception = " + e);
                            }
                            mess.getClass();
                            mess.SetToHeader(2, this.ip[0]);
                            mess.getClass();
                            mess.SetToHeader(3, this.ip[1]);
                            mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
                            mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
                            mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(8 + table_length_new));
                            mess.SetToBody(0, (short)(7 + table_length_new));
                            mess.SetToBody(1, (short)30);
                            mess.SetToBody(2, rack_ip[0]);
                            mess.SetToBody(3, rack_ip[1]);
                            mess.SetToBody(4, rack_ip[2]);
                            mess.SetToBody(5, rack_ip[3]);
                            mess.SetToBody(6, message.GetFromBody(1));
                            mess.SetToBody(7, (short)table_length_new);
                            try {
                                for (i = 0; i < table_length_new; ++i) {
                                    mess.SetToBody(8 + i, status_hi_lo_array_new[i]);
                                }
                            }
                            catch (Exception e) {
                                System.out.println("GUI: SendGUI_BlockState(): (message fill) i = " + i + ", max_element = " + i * 2 + ", arr_size = " + table_length_old + ", Exception = " + e);
                                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): (message fill) i = " + i + ", max_element = " + i * 2 + ", arr_size = " + table_length_old + ", Exception = " + e);
                            }
                            if (this.show_block_state_messages) {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss:SSS");
                                Date date = new Date();
                                String date_str = sdf.format(date);
                                System.out.println("GUI.SendGUI_BlockState():  (gui_ip = " + this.ip_str + "),  time = ( " + date_str + " ), message = " + mess.toString());
                                this.dialog.AddLogRecord("GUI.SendGUI_BlockState():  (gui_ip = " + this.ip_str + "),  time = ( " + date_str + " ), message = " + mess.toString());
                            }
                            this.socket.Write(mess);
                            return;
                        }
                        boolean pppp = false;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("GUI: SendGUI_BlockState(): " + e);
                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): " + e);
                this.dialog.AddLogRecord("GUI: SendGUI_BlockState(): message = " + message.toString());
            }
        }
    }

    public void SendGUI_JournalRecord(String record) {
        try {
            int j;
            byte[] byte_array;
            String field_string;
            char ch;
            int i = 0;
            boolean begin_record_index = false;
            int end_record_index = 0;
            int full_message_length = 0;
            short year = 0;
            short month = 0;
            short day = 0;
            boolean year_b1 = false;
            boolean year_b2 = false;
            short hours = 0;
            short minutes = 0;
            short seconds = 0;
            short event_type = 0;
            short alarm_name_length = 0;
            short[] alarm_name = new short[]{};
            short alarm_index = 0;
            short ip_b1 = 0;
            short ip_b2 = 0;
            short ip_b3 = 0;
            short ip_b4 = 0;
            short rack_name_length = 0;
            short[] rack_name = new short[]{};
            short slot = 0;
            short card_code_b1 = 0;
            short card_code_b2 = 0;
            short card_code_b3 = 0;
            short card_code_b4 = 0;
            short card_name_length = 0;
            short[] card_name = new short[]{};
            for (i = 0; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ' ') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 1;
                try {
                    String[] date_string_array = field_string.split("-");
                    year = Short.parseShort(date_string_array[0], 10);
                    month = Short.parseShort(date_string_array[1], 10);
                    day = Short.parseShort(date_string_array[2], 10);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line date convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line date convertion invalid format : " + e);
                }
                break;
            }
            full_message_length += 4;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != '=') continue;
                field_string = record.substring(end_record_index, i - 1);
                end_record_index = i + 1;
                try {
                    String[] time_string_array = field_string.split(":");
                    hours = (short)Integer.parseInt(time_string_array[0], 10);
                    minutes = (short)Integer.parseInt(time_string_array[1], 10);
                    seconds = (short)Integer.parseInt(time_string_array[2], 10);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line time convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line time convertion invalid format : " + e);
                }
                break;
            }
            full_message_length += 3;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                field_string = field_string.replace(" ", "");
                end_record_index = i + 2;
                try {
                    if (field_string.equals("ALARM_ON")) {
                        event_type = 1;
                    }
                    if (field_string.equals("ALARM_OFF")) {
                        event_type = 2;
                    }
                    if (field_string.equals("RACK_LOST")) {
                        event_type = 3;
                    }
                    if (field_string.equals("RACK_FOUND")) {
                        event_type = 4;
                    }
                    if (field_string.equals("CARD_LOST")) {
                        event_type = 3;
                    }
                    if (field_string.equals("CARD_FOUND")) {
                        event_type = 4;
                    }
                    if (event_type != 0) break;
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line event_type convertion invalid format : " + field_string);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line event_type convertion invalid format : " + field_string);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line event_type convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line event_type convertion invalid format : " + e);
                }
                break;
            }
            ++full_message_length;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 2;
                try {
                    byte_array = field_string.getBytes();
                    alarm_name_length = (short)byte_array.length;
                    ++full_message_length;
                    alarm_name = new short[byte_array.length];
                    full_message_length += byte_array.length;
                    j = 0;
                    for (j = 0; j < byte_array.length; ++j) {
                        alarm_name[j] = byte_array[j];
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line alarm_name convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line alarm_name convertion invalid format : " + e);
                    break;
                }
            }
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 2;
                try {
                    alarm_index = (short)(Integer.parseInt(field_string) & 0xFF);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line alarm_name convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line alarm_name convertion invalid format : " + e);
                }
                break;
            }
            ++full_message_length;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 2;
                try {
                    String[] ip_string_array = field_string.split("\\.");
                    ip_b1 = (short)Integer.parseInt(ip_string_array[0], 10);
                    ip_b2 = (short)Integer.parseInt(ip_string_array[1], 10);
                    ip_b3 = (short)Integer.parseInt(ip_string_array[2], 10);
                    ip_b4 = (short)Integer.parseInt(ip_string_array[3], 10);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line ip-address convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal file line ip-address convertion invalid format : " + e);
                }
                break;
            }
            full_message_length += 4;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 2;
                try {
                    byte_array = field_string.getBytes();
                    rack_name_length = (short)byte_array.length;
                    ++full_message_length;
                    rack_name = new short[byte_array.length];
                    full_message_length += byte_array.length;
                    j = 0;
                    for (j = 0; j < byte_array.length; ++j) {
                        rack_name[j] = byte_array[j];
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line alarm_name convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line alarm_name convertion invalid format : " + e);
                    break;
                }
            }
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                field_string.replace(" ", "");
                end_record_index = i + 2;
                try {
                    slot = (short)Integer.parseInt(field_string, 10);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line slot_number convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line slot_number convertion invalid format : " + e);
                }
                break;
            }
            ++full_message_length;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                field_string.replace(" ", "");
                end_record_index = i + 2;
                try {
                    short n_card_code = (short)Integer.parseInt(field_string, 10);
                    card_code_b1 = (short)(n_card_code >> 24);
                    card_code_b2 = (short)(n_card_code >> 16 & 0xFF);
                    card_code_b3 = (short)(n_card_code >> 8 & 0xFF);
                    card_code_b4 = (short)(n_card_code & 0xFF);
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line slot_number convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line slot_number convertion invalid format : " + e);
                }
                break;
            }
            full_message_length += 4;
            for (i = end_record_index; i < record.length(); ++i) {
                ch = record.charAt(i);
                if (ch != ';') continue;
                field_string = record.substring(end_record_index, i);
                end_record_index = i + 2;
                try {
                    byte[] byte_array2 = field_string.getBytes();
                    card_name_length = (short)byte_array2.length;
                    ++full_message_length;
                    card_name = new short[byte_array2.length];
                    full_message_length += byte_array2.length;
                    j = 0;
                    for (j = 0; j < byte_array2.length; ++j) {
                        card_name[j] = byte_array2[j];
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_JournalRecord() -> journal file line alarm_name convertion invalid format : " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> journal line alarm_name convertion invalid format : " + e);
                    break;
                }
            }
            boolean ppp = false;
            int message_index = 0;
            Message mess = new Message();
            mess.getClass();
            mess.SetToHeader(2, this.ip[0]);
            mess.getClass();
            mess.SetToHeader(3, this.ip[1]);
            mess.SetToHeader(mess.POS_MESSAGE_IP3, this.ip[2]);
            mess.SetToHeader(mess.POS_MESSAGE_IP4, this.ip[3]);
            mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(full_message_length + 1));
            mess.SetToBody(0, (short)full_message_length);
            mess.SetToBody(1, (short)140);
            mess.SetToBody(2, day);
            mess.SetToBody(3, month);
            mess.SetToBody(4, year);
            mess.SetToBody(5, hours);
            mess.SetToBody(6, minutes);
            mess.SetToBody(7, seconds);
            mess.SetToBody(8, event_type);
            mess.SetToBody(9, alarm_index);
            message_index = 9;
            mess.SetToBody(message_index + 1, alarm_name_length);
            ++message_index;
            for (i = 0; i < alarm_name_length; ++i) {
                mess.SetToBody(message_index + 1 + i, alarm_name[i]);
            }
            mess.SetToBody((message_index += alarm_name_length) + 1, ip_b1);
            mess.SetToBody(message_index + 2, ip_b2);
            mess.SetToBody(message_index + 3, ip_b3);
            mess.SetToBody(message_index + 4, ip_b4);
            mess.SetToBody((message_index += 4) + 1, rack_name_length);
            ++message_index;
            for (i = 0; i < rack_name_length; ++i) {
                mess.SetToBody(message_index + 1 + i, rack_name[i]);
            }
            mess.SetToBody((message_index += rack_name_length) + 1, slot);
            mess.SetToBody(++message_index + 1, card_code_b1);
            mess.SetToBody(message_index + 2, card_code_b2);
            mess.SetToBody(message_index + 3, card_code_b3);
            mess.SetToBody(message_index + 4, card_code_b4);
            mess.SetToBody((message_index += 4) + 1, card_name_length);
            ++message_index;
            for (i = 0; i < card_name_length; ++i) {
                mess.SetToBody(message_index + 1 + i, card_name[i]);
            }
            message_index += card_name_length;
            if (this.socket != null) {
                this.socket.Write(mess);
                this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> sending journal record: " + record);
                this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> sending journal record: MESSAGE = " + mess.toString());
                System.out.println("GUI.SendGUI_JournalRecord() -> sending journal record: " + record);
                System.out.println("GUI.SendGUI_JournalRecord() -> sending journal record: MESSAGE = " + mess.toString());
            }
        }
        catch (Exception e) {
            System.out.println("GUI.SendGUI_JournalRecord() -> record parsing : " + e);
            this.dialog.AddLogRecord("GUI.SendGUI_JournalRecord() -> record parsing : " + e);
        }
    }

    public void SendGUI_Full_Init_Info() {
        this.timer.schedule(this.timerTask, 1000L);
    }

    public void SendGUI_Full_Init_Info_Timer() {
        block21: {
            if (!this.b_gui_ready || !this.b_first_pulse_sent) {
                return;
            }
            try {
                try {
                    this.SendGUI_DefaultBlocksAlarmsFiles();
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_Full_Init_Info(): SendGUI_DefaultBlocksAlarmsFiles()" + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): SendGUI_DefaultBlocksAlarmsFiles()" + e);
                }
                try {
                    this.SendGUI_ResolvedRacks();
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_Full_Init_Info(): SendGUI_ResolvedRacks()" + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): SendGUI_ResolvedRacks()" + e);
                }
                try {
                    this.SendGUI_PreferredRacks();
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_Full_Init_Info(): SendGUI_PreferredRacks()" + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): SendGUI_PreferredRacks()" + e);
                }
                try {
                    this.SendGUI_RackNames();
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_Full_Init_Info(): SendGUI_RackNames()" + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): SendGUI_RackNames()" + e);
                }
                try {
                    ArrayList<ProflexRack> tmp_observers_racks_list = new ArrayList<ProflexRack>(this.observers_racks_list);
                    if (tmp_observers_racks_list.size() > 0) {
                        System.out.println("GUI.SendGUI_Full_Init_Info(): observers racks num = " + tmp_observers_racks_list.size());
                        this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): observers racks num = " + tmp_observers_racks_list.size());
                        int index = 0;
                        try {
                            for (ProflexRack rack : tmp_observers_racks_list) {
                                ++index;
                                try {
                                    String client_info = "SendGUI_Full_Init_Info(): GUI (IP = " + String.valueOf(this.ip[0]) + "." + String.valueOf(this.ip[1]) + "." + String.valueOf(this.ip[2]) + "." + String.valueOf(this.ip[3]) + ") " + " RACK (IP = " + String.valueOf(rack.ipAddress_short[0]) + "." + String.valueOf(rack.ipAddress_short[1]) + "." + String.valueOf(rack.ipAddress_short[2]) + "." + String.valueOf(rack.ipAddress_short[3]) + ")";
                                    String str_mess = "GUI." + client_info;
                                    System.out.println(str_mess);
                                    this.dialog.AddLogRecord(str_mess);
                                    try {
                                        rack.SendGui_AllRack(this);
                                    }
                                    catch (Exception e) {
                                        System.out.println("GUI.SendGUI_Full_Init_Info(): rack sending (index = " + index + "; client_info = " + client_info + ") = " + e);
                                        this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): rack sending (index = " + index + "; client_info = " + client_info + ") = " + e);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println("GUI.SendGUI_Full_Init_Info(): observer-rack sending (index = " + index + ") = " + e);
                                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): observer-rack sending (index = " + index + ") = " + e);
                                }
                            }
                            break block21;
                        }
                        catch (Exception e) {
                            System.out.println("GUI.SendGUI_Full_Init_Info(): observers racks list error. Size = " + tmp_observers_racks_list.size() + " index = " + index);
                            this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): observers racks list error. Size = " + tmp_observers_racks_list.size() + " index = " + index);
                            break block21;
                        }
                    }
                    System.out.println("GUI.SendGUI_Full_Init_Info(): observers racks num = " + tmp_observers_racks_list.size());
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): observers racks num = " + tmp_observers_racks_list.size());
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_Full_Init_Info(): racks info loop" + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): racks info loop" + e);
                }
            }
            catch (Exception e) {
                System.out.println("GUI.SendGUI_Full_Init_Info(): " + e);
                this.dialog.AddLogRecord("GUI.SendGUI_Full_Init_Info(): " + e);
            }
        }
    }

    @Override
    public void GetObjectConfig() {
        try {
            for (CoreSetting s : this.settings) {
                s.GetSetting();
            }
        }
        catch (Exception e) {
            System.out.println("GUI.GetObjectConfig(): " + e);
            this.dialog.AddLogRecord("GUI.GetObjectConfig(): " + e);
        }
    }

    @Override
    public void AddObserver(ObserverObject observer) {
        try {
            this.observers_racks_list.add((ProflexRack)observer);
            short[] list_rack_ip = ((ProflexRack)observer).getIP();
            if (this.show_add_delete_rack_messages) {
                String str_full = "";
                String list_rack_ip_str = String.valueOf(list_rack_ip[0]) + "." + String.valueOf(list_rack_ip[1]) + "." + String.valueOf(list_rack_ip[2]) + "." + String.valueOf(list_rack_ip[3]);
                str_full = "GUI -> AddObserver(): adding rack: (rack = " + list_rack_ip_str + ") rack_list =  ";
                for (ProflexRack rack_list : this.observers_racks_list) {
                    short[] list_rack_new_ip_short = rack_list.getIP();
                    list_rack_ip_str = String.valueOf(list_rack_new_ip_short[0]) + "." + String.valueOf(list_rack_new_ip_short[1]) + "." + String.valueOf(list_rack_new_ip_short[2]) + "." + String.valueOf(list_rack_new_ip_short[3]);
                    str_full = str_full + list_rack_ip_str + ", ";
                }
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
            }
        }
        catch (Exception e) {
            System.out.println("GUI -> AddObserver() : " + e);
            this.dialog.AddLogRecord("GUI -> AddObserver() : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessNewPreferredIP(Message message) {
        short[] dest_setting_ip = new short[4];
        dest_setting_ip = this.GetIP();
        String dest_setting_ip_str = String.valueOf(dest_setting_ip[0]) + "." + String.valueOf(dest_setting_ip[1]) + "." + String.valueOf(dest_setting_ip[2]) + "." + String.valueOf(dest_setting_ip[3]);
        int blocks_num = message.GetFromBody(2);
        short[] ip = new short[4];
        ArrayList list = new ArrayList();
        ArrayList<String> fileStrings = new ArrayList<String>();
        try {
            int t;
            String s;
            FileReader fileReader = new FileReader(this.DEFAULT_GUI_SETTINGS_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    fileStrings.add(s);
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewPreferredIP() -> file read: " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> file read : " + e);
            }
            boolean isBlockFound = false;
            boolean isRecordFound = false;
            int insertLineIndex = 0;
            int i = 0;
            int j = 0;
            try {
                for (i = 0; i < fileStrings.size(); ++i) {
                    String file_ip;
                    s = (String)fileStrings.get(i);
                    if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']' || !(file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1)).equals(dest_setting_ip_str)) continue;
                    isBlockFound = true;
                    try {
                        for (j = i + 1; j < fileStrings.size(); ++j) {
                            String s_block_new;
                            String s_block = (String)fileStrings.get(j);
                            if (s_block.charAt(0) == '[' && s_block.charAt(s_block.length() - 1) == ']') {
                                isRecordFound = true;
                                s_block_new = "preferred_rack_list = ";
                                t = 0;
                                for (t = 0; t < blocks_num; ++t) {
                                    ip[0] = message.GetFromBody(3 + t * 4);
                                    ip[1] = message.GetFromBody(3 + t * 4 + 1);
                                    ip[2] = message.GetFromBody(3 + t * 4 + 2);
                                    ip[3] = message.GetFromBody(3 + t * 4 + 3);
                                    s_block_new = s_block_new + String.valueOf(ip[0]) + "." + String.valueOf(ip[1]) + "." + String.valueOf(ip[2]) + "." + String.valueOf(ip[3]);
                                    if (t >= blocks_num - 1) continue;
                                    s_block_new = s_block_new + ", ";
                                }
                                fileStrings.add(j - 1, s_block_new);
                            } else {
                                if (!(s_block = s_block.replaceAll(" ", "")).contains("preferred_rack_list")) continue;
                                isRecordFound = true;
                                s_block_new = "preferred_rack_list = ";
                                t = 0;
                                for (t = 0; t < blocks_num; ++t) {
                                    ip[0] = message.GetFromBody(3 + t * 4);
                                    ip[1] = message.GetFromBody(3 + t * 4 + 1);
                                    ip[2] = message.GetFromBody(3 + t * 4 + 2);
                                    ip[3] = message.GetFromBody(3 + t * 4 + 3);
                                    s_block_new = s_block_new + String.valueOf(ip[0]) + "." + String.valueOf(ip[1]) + "." + String.valueOf(ip[2]) + "." + String.valueOf(ip[3]);
                                    if (t >= blocks_num - 1) continue;
                                    s_block_new = s_block_new + ", ";
                                }
                                fileStrings.set(j, s_block_new);
                                this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> new record in gui_config.conf at [" + j + "] line = " + s_block_new);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("GUI.ProcessNewPreferredIP() -> file strings record searching: " + e);
                        this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> file strings record searching: " + e);
                    }
                    insertLineIndex = j - 1;
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewPreferredIP() -> file strings block searching: " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> file strings block searching: " + e);
            }
            if (!isBlockFound) {
                String s_blosk_new = "";
                s_blosk_new = "[" + String.valueOf(dest_setting_ip[0]) + "." + String.valueOf(dest_setting_ip[1]) + "." + String.valueOf(dest_setting_ip[2]) + "." + String.valueOf(dest_setting_ip[3]) + "]";
                fileStrings.add(s_blosk_new);
                String s_record_new = "preferred_rack_list = ";
                int t2 = 0;
                for (t2 = 0; t2 < blocks_num; ++t2) {
                    ip[0] = message.GetFromBody(3 + t2 * 4);
                    ip[1] = message.GetFromBody(3 + t2 * 4 + 1);
                    ip[2] = message.GetFromBody(3 + t2 * 4 + 2);
                    ip[3] = message.GetFromBody(3 + t2 * 4 + 3);
                    s_record_new = s_record_new + String.valueOf(ip[0]) + "." + String.valueOf(ip[1]) + "." + String.valueOf(ip[2]) + "." + String.valueOf(ip[3]);
                    if (t2 >= blocks_num - 1) continue;
                    s_record_new = s_record_new + ", ";
                }
                fileStrings.add(s_record_new);
            } else if (!isRecordFound) {
                String s_record_new = "preferred_rack_list = ";
                t = 0;
                for (t = 0; t < blocks_num; ++t) {
                    ip[0] = message.GetFromBody(3 + t * 4);
                    ip[1] = message.GetFromBody(3 + t * 4 + 1);
                    ip[2] = message.GetFromBody(3 + t * 4 + 2);
                    ip[3] = message.GetFromBody(3 + t * 4 + 3);
                    s_record_new = s_record_new + String.valueOf(ip[0]) + "." + String.valueOf(ip[1]) + "." + String.valueOf(ip[2]) + "." + String.valueOf(ip[3]);
                    if (t >= blocks_num - 1) continue;
                    s_record_new = s_record_new + ", ";
                }
                fileStrings.add(insertLineIndex, s_record_new);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.DEFAULT_GUI_SETTINGS_FILENAME);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
                try {
                    for (i = 0; i < fileStrings.size(); ++i) {
                        String line = (String)fileStrings.get(i);
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("GUI.ProcessNewPreferredIP() -> gui_config.conf file write : " + ex);
                    this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> gui_config.conf file write : " + ex);
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException ex) {
                        System.out.println("GUI.ProcessNewPreferredIP() -> gui_config.conf file close : " + ex);
                        this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> gui_config.conf file close : " + ex);
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ex) {
                        System.out.println("GUI.ProcessNewPreferredIP() -> gui_config.conf file close : " + ex);
                        this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> gui_config.conf file close : " + ex);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewPreferredIP() -> gui_config.conf file open : " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> gui_config.conf file open : " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI.ProcessNewPreferredIP() -> gui_config.conf file read: " + e);
            this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> gui_config.conf file read : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessNewMonitoringSetting(Message message) {
        short[] dest_setting_ip = new short[]{message.GetFromBody(3), message.GetFromBody(4), message.GetFromBody(5), message.GetFromBody(6)};
        String dest_setting_ip_str = String.valueOf(dest_setting_ip[0]) + "." + String.valueOf(dest_setting_ip[1]) + "." + String.valueOf(dest_setting_ip[2]) + "." + String.valueOf(dest_setting_ip[3]);
        short slot = message.GetFromBody(7);
        short setting_number = message.GetFromBody(8);
        short checking_flag = message.GetFromBody(9);
        short lowerLim = message.GetFromBody(10);
        short upperLim = message.GetFromBody(11);
        short invalidValue = message.GetFromBody(12);
        short isActive = message.GetFromBody(13);
        short isSendTrap = message.GetFromBody(14);
        short gui_table_line_index = message.GetFromBody(15);
        short block_code_b1 = message.GetFromBody(16);
        short block_code_b2 = message.GetFromBody(17);
        short block_code_b3 = message.GetFromBody(18);
        short block_code_b4 = message.GetFromBody(19);
        long block_code_full = 0L;
        block_code_full |= (long)(block_code_b1 << 24);
        block_code_full |= (long)(block_code_b2 << 16);
        block_code_full |= (long)(block_code_b3 << 8);
        ArrayList<String> fileStrings = new ArrayList<String>();
        String s_message = "GUI.ProcessNewMonitoringSetting(): values from message = ";
        String s_values = String.valueOf(slot) + ";" + String.valueOf(setting_number) + ";" + String.valueOf(checking_flag) + ";" + String.valueOf(lowerLim) + ";" + String.valueOf(upperLim) + ";" + String.valueOf(invalidValue) + ";" + String.valueOf(isActive) + ";" + String.valueOf(isSendTrap) + ";" + String.valueOf(gui_table_line_index) + ";" + String.valueOf(block_code_full |= (long)block_code_b4);
        s_message = s_message + s_values;
        System.out.println(s_message);
        this.dialog.AddLogRecord(s_message);
        try {
            String s;
            FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    fileStrings.add(s);
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("GUI.WriteMonitoringSetting() -> monitoring file read: " + e);
                this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file read : " + e);
            }
            boolean isBlockFound = false;
            boolean isRecordFound = false;
            int insertLineIndex = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            try {
                for (i = 0; i < fileStrings.size(); ++i) {
                    String file_ip;
                    s = (String)fileStrings.get(i);
                    if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']' || !(file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1)).equals(dest_setting_ip_str)) continue;
                    isBlockFound = true;
                    try {
                        for (j = i + 1; j < fileStrings.size(); ++j) {
                            String s_block = (String)fileStrings.get(j);
                            if (s_block.charAt(0) == '[' && s_block.charAt(s_block.length() - 1) == ']') {
                                isRecordFound = true;
                                String s_block_new = "";
                                s_block_new = String.valueOf(slot) + ";" + String.valueOf(setting_number) + ";" + String.valueOf(checking_flag) + ";" + String.valueOf(lowerLim) + ";" + String.valueOf(upperLim) + ";" + String.valueOf(invalidValue) + ";" + String.valueOf(isActive) + ";" + String.valueOf(isSendTrap) + ";" + String.valueOf(gui_table_line_index) + ";" + String.valueOf(block_code_full);
                                fileStrings.add(j - 1, s_block_new);
                            } else {
                                s_block = s_block.replaceAll(" ", "");
                                String[] splitted = s_block.split(";");
                                int[] table = new int[10];
                                for (k = 0; k < 10; ++k) {
                                    table[k] = Integer.parseInt(splitted[k]);
                                    if (splitted[k] != "0") continue;
                                    table[k] = 0;
                                }
                                if (table[0] != slot || table[1] != setting_number) continue;
                                isRecordFound = true;
                                String s_block_new = "";
                                s_block_new = String.valueOf(slot) + ";" + String.valueOf(setting_number) + ";" + String.valueOf(checking_flag) + ";" + String.valueOf(lowerLim) + ";" + String.valueOf(upperLim) + ";" + String.valueOf(invalidValue) + ";" + String.valueOf(isActive) + ";" + String.valueOf(isSendTrap) + ";" + String.valueOf(gui_table_line_index) + ";" + String.valueOf(block_code_full);
                                fileStrings.set(j, s_block_new);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("GUI.WriteMonitoringSetting() -> file strings record searching: " + e);
                        this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> file strings record searching: " + e);
                    }
                    insertLineIndex = j - 1;
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("GUI.WriteMonitoringSetting() -> file strings block searching: " + e);
                this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> file strings block searching: " + e);
            }
            if (!isBlockFound) {
                String s_blosk_new = "";
                s_blosk_new = "[" + String.valueOf(dest_setting_ip[0]) + "." + String.valueOf(dest_setting_ip[1]) + "." + String.valueOf(dest_setting_ip[2]) + "." + String.valueOf(dest_setting_ip[3]) + "]";
                fileStrings.add(s_blosk_new);
                String s_record_new = "";
                s_record_new = String.valueOf(slot) + ";" + String.valueOf(setting_number) + ";" + String.valueOf(checking_flag) + ";" + String.valueOf(lowerLim) + ";" + String.valueOf(upperLim) + ";" + String.valueOf(invalidValue) + ";" + String.valueOf(isActive) + ";" + String.valueOf(isSendTrap) + ";" + String.valueOf(gui_table_line_index) + ";" + String.valueOf(block_code_full);
                fileStrings.add(s_record_new);
            } else if (!isRecordFound) {
                String s_record_new = "";
                s_record_new = String.valueOf(slot) + ";" + String.valueOf(setting_number) + ";" + String.valueOf(checking_flag) + ";" + String.valueOf(lowerLim) + ";" + String.valueOf(upperLim) + ";" + String.valueOf(invalidValue) + ";" + String.valueOf(isActive) + ";" + String.valueOf(isSendTrap) + ";" + String.valueOf(gui_table_line_index) + ";" + String.valueOf(block_code_full);
                fileStrings.add(insertLineIndex, s_record_new);
            }
        }
        catch (Exception e) {
            System.out.println("GUI.WriteMonitoringSetting() -> monitoring file read: " + e);
            this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file read : " + e);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            try {
                int i = 0;
                for (i = 0; i < fileStrings.size(); ++i) {
                    String line = (String)fileStrings.get(i);
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (IOException ex) {
                System.out.println("GUI.WriteMonitoringSetting() -> monitoring file write : " + ex);
                this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file write : " + ex);
            }
            finally {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("GUI.WriteMonitoringSetting() -> monitoring file close : " + ex);
                    this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file close : " + ex);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    System.out.println("GUI.WriteMonitoringSetting() -> monitoring file close : " + ex);
                    this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file close : " + ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI.WriteMonitoringSetting() -> monitoring file open : " + e);
            this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> monitoring file open : " + e);
        }
        for (ProflexRack rack : this.observers_racks_list) {
            String rack_ip_str = rack.ipAddress.toString();
            if (!rack_ip_str.equals(dest_setting_ip_str)) continue;
            rack.SendGuiObservers_UserBLockAlarmsFile();
        }
        try {
            for (ProflexRack rack : this.observers_racks_list) {
                if (!Arrays.equals(rack.getIP(), dest_setting_ip)) continue;
                try {
                    for (ProflexCard card : rack.cards_list) {
                        if (card.slot != slot) continue;
                        try {
                            for (ProflexSetting setting : card.proflexSettings) {
                                if (setting.setting_number != setting_number) continue;
                                setting.LoadSettings();
                                setting.SendGUI_CurrentAlarmState();
                                setting.CheckMonitoringParams();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("GUI.WriteMonitoringSetting() -> find setting : " + e);
                            this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> find setting : " + e);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("GUI.WriteMonitoringSetting() -> find card : " + e);
                    this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> find card : " + e);
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI.WriteMonitoringSetting() -> find rack : " + e);
            this.dialog.AddLogRecord("GUI.WriteMonitoringSetting() -> find rack : " + e);
        }
    }

    public void ReloadMonitoringSetting() {
        try {
            for (ProflexRack rack : this.observers_racks_list) {
                for (ProflexCard card : rack.cards_list) {
                    for (ProflexSetting setting : card.proflexSettings) {
                        setting.LoadSettings();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI.ReloadMonitoringSetting(): " + e);
            this.dialog.AddLogRecord("GUI.ReloadMonitoringSetting(): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessNewRackName(Message message) {
        short[] dest_setting_ip = new short[4];
        byte[] new_rack_name = new byte[256];
        int new_rack_name_length = 0;
        String dest_setting_ip_str = "";
        String new_rack_name_str = "";
        int existing_record_index = 0;
        try {
            dest_setting_ip[0] = message.GetFromBody(2);
            dest_setting_ip[1] = message.GetFromBody(3);
            dest_setting_ip[2] = message.GetFromBody(4);
            dest_setting_ip[3] = message.GetFromBody(5);
            dest_setting_ip_str = String.valueOf(dest_setting_ip[0]) + "." + String.valueOf(dest_setting_ip[1]) + "." + String.valueOf(dest_setting_ip[2]) + "." + String.valueOf(dest_setting_ip[3]);
            new_rack_name_length = message.GetFromBody(6);
            int k = 0;
            for (k = 0; k < new_rack_name_length; ++k) {
                new_rack_name[k] = (byte)(0xFF & message.GetFromBody(7 + k));
            }
            String tmp_str = new String(new_rack_name);
            new_rack_name_str = tmp_str.substring(0, new_rack_name_length);
        }
        catch (Exception e) {
            System.out.println("GUI.ProcessNewRackName() -> message_rack_name converting: " + e);
            this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> message_rack_name converting : " + e);
        }
        short[] ip = new short[4];
        ArrayList list = new ArrayList();
        ArrayList<String> fileStrings = new ArrayList<String>();
        try {
            String s;
            FileReader fileReader = new FileReader(this.DEFAULT_RACK_NAMES_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    fileStrings.add(s);
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewRackName() -> file read: " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> file read : " + e);
            }
            String file_ip = " ";
            boolean isBlockFound = false;
            boolean isRecordFound = false;
            boolean insertLineIndex = false;
            int i = 0;
            int j = 0;
            try {
                for (i = 0; i < fileStrings.size(); ++i) {
                    s = (String)fileStrings.get(i);
                    for (j = 0; j < s.length(); ++j) {
                        if (s.charAt(j) != '=') continue;
                        file_ip = s.substring(0, j - 1);
                        break;
                    }
                    if (!file_ip.equals(dest_setting_ip_str)) continue;
                    isRecordFound = true;
                    existing_record_index = i;
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewPreferredIP() -> file strings block searching: " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewPreferredIP() -> file strings block searching: " + e);
            }
            String s_record_new = "";
            s_record_new = dest_setting_ip_str + " = " + new_rack_name_str;
            if (!isRecordFound) {
                fileStrings.add(s_record_new);
            } else {
                fileStrings.set(existing_record_index, s_record_new);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.DEFAULT_RACK_NAMES_FILENAME);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
                try {
                    for (i = 0; i < fileStrings.size(); ++i) {
                        String line = (String)fileStrings.get(i);
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("GUI.ProcessNewRackName() -> gui_config.conf file write : " + ex);
                    this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> gui_config.conf file write : " + ex);
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException ex) {
                        System.out.println("GUI.ProcessNewRackName() -> gui_config.conf file close : " + ex);
                        this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> gui_config.conf file close : " + ex);
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ex) {
                        System.out.println("GUI.ProcessNewRackName() -> gui_config.conf file close : " + ex);
                        this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> gui_config.conf file close : " + ex);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("GUI.ProcessNewRackName() -> gui_config.conf file open : " + e);
                this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> gui_config.conf file open : " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI.ProcessNewRackName() -> gui_config.conf file read: " + e);
            this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> gui_config.conf file read : " + e);
        }
        try {
            this.SendGUI_RackNames();
        }
        catch (Exception e) {
            System.out.println("GUI.ProcessNewRackName() -> sending new names: " + e);
            this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> sending new names: " + e);
        }
    }

    public void SendGUI_RackNames() {
        short[] ip = new short[4];
        ArrayList list = new ArrayList();
        ArrayList<String> fileStrings = new ArrayList<String>();
        try {
            try {
                FileReader fileReader = new FileReader(this.DEFAULT_RACK_NAMES_FILENAME);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    String s;
                    while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                        fileStrings.add(s);
                    }
                    fileReader.close();
                }
                catch (Exception e) {
                    System.out.println("GUI.SendGUI_RackNames() -> file read: " + e);
                    this.dialog.AddLogRecord("GUI.SendGUI_RackNames() -> file read : " + e);
                }
            }
            catch (Exception e) {
                System.out.println("GUI.SendGUI_RackNames() -> rack_names.conf file read: " + e);
                this.dialog.AddLogRecord("GUI.SendGUI_RackNames() -> rack_names.conf file read : " + e);
            }
            int i = 0;
            String ip_str = "";
            int ip_length = 0;
            String name_str = "";
            int name_length = 0;
            short ip_b1 = 0;
            short ip_b2 = 0;
            short ip_b3 = 0;
            short ip_b4 = 0;
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ip[0]);
            message.getClass();
            message.SetToHeader(3, this.ip[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ip[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ip[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)0);
            message.SetToBody(1, (short)161);
            int message_length = 2;
            int message_blocks_count = 0;
            int message_last_index = 2;
            block7: for (String file_line : fileStrings) {
                for (i = 0; i < file_line.length(); ++i) {
                    if (file_line.charAt(i) != '=') continue;
                    ip_length = i - 1;
                    ip_str = file_line.substring(0, ip_length);
                    name_length = file_line.length() - (ip_length + 2);
                    name_str = file_line.substring(ip_length + 2, file_line.length());
                    String[] ip_string_array = ip_str.split("\\.");
                    ip_b1 = (short)Integer.parseInt(ip_string_array[0], 10);
                    ip_b2 = (short)Integer.parseInt(ip_string_array[1], 10);
                    ip_b3 = (short)Integer.parseInt(ip_string_array[2], 10);
                    ip_b4 = (short)Integer.parseInt(ip_string_array[3], 10);
                    break;
                }
                for (IpAddress res_ip : this.resolved_rack_list) {
                    if (!ip_str.equals(res_ip.toString())) continue;
                    message.SetToBody(message_last_index + 1, ip_b1);
                    message.SetToBody(message_last_index + 2, ip_b2);
                    message.SetToBody(message_last_index + 3, ip_b3);
                    message.SetToBody(message_last_index + 4, ip_b4);
                    message.SetToBody((message_last_index += 4) + 1, (short)name_length);
                    ++message_last_index;
                    for (i = 0; i < name_str.length(); ++i) {
                        message.SetToBody(message_last_index + 1, (short)name_str.charAt(i));
                        ++message_last_index;
                    }
                    ++message_blocks_count;
                    continue block7;
                }
            }
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(message_last_index + 1));
            message.SetToBody(0, (short)message_last_index);
            message.SetToBody(1, (short)161);
            message.SetToBody(2, (short)message_blocks_count);
            if (message_blocks_count > 0) {
                this.socket.Write(message);
                if (this.show_rack_structure_messages) {
                    System.out.println("GUI.SendGUI_RackNames():  (gui_ip = " + this.ip_str + "),  message = " + message.toString());
                    this.dialog.AddLogRecord("GUI.SendGUI_RackNames():  (gui_ip = " + this.ip_str + "),  message = " + message.toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI.SendGUI_RackNames(): " + e);
            this.dialog.AddLogRecord("GUI.SendGUI_RackNames(): " + e);
        }
    }

    @Override
    public void RemoveObserver(ObserverObject observer) {
    }

    @Override
    public void NotifyObservers() {
    }

    @Override
    public void NotifyObservers(String str) {
        System.out.println(str);
    }

    @Override
    public void NotifyObservers(Message message) {
    }

    public class Pulse_Thread
    extends Thread {
        boolean is_running = false;

        public Pulse_Thread() {
            try {
                this.is_running = true;
                this.setDaemon(true);
                this.setPriority(5);
                this.start();
            }
            catch (Exception e) {
                System.out.println("GUI -> Pulse_Thread() : " + e);
            }
        }

        @Override
        public void run() {
            while (this.is_running) {
                try {
                    Gui.this.SendGUI_Pulse();
                    Pulse_Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    System.out.println("GUI -> Pulse_Thread() : " + e);
                }
            }
        }
    }

    public class Full_Init_Info_Thread
    extends Thread {
        public Full_Init_Info_Thread() {
            try {
                this.setDaemon(true);
                this.setPriority(2);
                this.start();
            }
            catch (Exception e) {
                System.out.println("GUI -> Full_Init_Info_Thread() : " + e);
            }
        }

        @Override
        public void run() {
            Gui.this.dialog.AddLogRecord("Gui() -> Full_Init_Info_Thread: start");
            Gui.this.SendGUI_Full_Init_Info_Timer();
            Gui.this.b_full_init_info_sent = true;
            Gui.this.dialog.AddLogRecord("Gui() -> Full_Init_Info_Thread: end");
        }
    }

    public class MyTask_Pulse
    extends TimerTask {
        @Override
        public void run() {
        }
    }

    public class MyTask
    extends TimerTask {
        @Override
        public void run() {
            Gui.this.b_gui_ready = true;
            Full_Init_Info_Thread full_init_info_thread = new Full_Init_Info_Thread();
        }
    }
}

