/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Journal {
    public final String DEFAULT_JOURNAL_NETWORK_FOLDER_NAME = "journal_network";
    public final String DEFAULT_JOURNAL_CORE_FOLDER_NAME = "journal_core";
    public final String DEFAULT_NETWORK_JOURNAL_FILENAME = "journal_network.txt";
    public final String DEFAULT_TEST_NETWORK_JOURNAL_FILENAME = "journal_network_test.txt";
    public final String DEFAULT_CORE_JOURNAL_FILENAME = "journal_core.txt";
    public final String JCNAME = "journal_core-";
    public final String JCEXT = ".txt";
    public final String JNNAME = "journal_network-";
    public final String JNEXT = ".txt";
    public MainDialog dialog;
    Socket_TCP socket_tcp;
    long max_file_size = 0x100000L;

    public Journal(MainDialog dialog) {
        this.dialog = dialog;
        this.socket_tcp = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date1 = sdf.parse("2014-11-17 10:00:00:000");
            Date date2 = sdf.parse("2014-11-19 10:00:00:000");
            ArrayList strings = new ArrayList();
            boolean ppp = false;
        }
        catch (Exception e) {
            System.out.println("Journal.Journal() -> date parsing : " + e);
            this.dialog.AddLogRecord("Journal.Journal() -> date parsing : " + e);
        }
    }

    public void SetSocketTCP(Socket_TCP socket) {
        if (socket != null) {
            this.socket_tcp = socket;
        } else {
            System.out.println("Journal.SetSocketTCP() -> INVALID SOCKET ");
            this.dialog.AddLogRecord("Journal.SetSocketTCP() -> INVALID SOCKET ");
        }
    }

    public synchronized void AddRecords(ArrayList<String> lines) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void AddNetworkJournalRecord(String line) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.GetNetworkFileForWriting(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            try {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            catch (IOException ex) {
                System.out.println("Journal.AddRecords() -> journal file write : " + ex);
                this.dialog.AddLogRecord("Journal.AddRecords() -> journal file write : " + ex);
            }
            finally {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Journal.AddRecords() -> journal file open : " + e);
            this.dialog.AddLogRecord("Journal.AddRecords() -> journal file open : " + e);
        }
    }

    public synchronized String GetNetworkFileForWriting() {
        int maxIdx = -1;
        try {
            int i;
            File folder = new File(this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME);
            if (!folder.exists() || !folder.isDirectory()) {
                folder.mkdirs();
            }
            File[] listOfFiles = folder.listFiles();
            File last_file = null;
            for (i = 0; i < listOfFiles.length; ++i) {
                int Idx;
                if (!listOfFiles[i].isFile()) continue;
                String filename = listOfFiles[i].getName().toLowerCase();
                int n = filename.length();
                StringBuilder stringBuilder = new StringBuilder().append(this.JNNAME);
                this.getClass();
                if (n != stringBuilder.append(".txt").append(1).toString().length()) continue;
                this.getClass();
                filename = filename.replaceFirst(".txt", "");
                if (filename.length() != (this.JNNAME + 1).length() || !Character.isDigit(filename.charAt(this.JNNAME.length())) || (filename = filename.replaceFirst(this.JNNAME, "")).length() != 1 || !Character.isDigit(filename.charAt(0)) || maxIdx >= (Idx = Integer.parseInt(filename))) continue;
                maxIdx = Idx;
                last_file = listOfFiles[i];
            }
            if (maxIdx < 0 || last_file == null) {
                maxIdx = 0;
            } else if (last_file.length() >= this.max_file_size) {
                ++maxIdx;
            }
            if (maxIdx < 10) {
                StringBuilder stringBuilder = new StringBuilder().append(this.JNNAME).append(String.valueOf(maxIdx));
                this.getClass();
                String logfile_full_name = stringBuilder.append(".txt").toString();
                String logfile_full_path = this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME + File.separator + logfile_full_name;
                return logfile_full_path;
            }
            for (i = 1; i < 10; ++i) {
                StringBuilder stringBuilder = new StringBuilder().append(this.JNNAME).append(String.valueOf(i - 1));
                this.getClass();
                String logfile_full_name0 = stringBuilder.append(".txt").toString();
                String logfile_full_path0 = this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME + File.separator + logfile_full_name0;
                StringBuilder stringBuilder2 = new StringBuilder().append(this.JNNAME).append(String.valueOf(i));
                this.getClass();
                String logfile_full_name1 = stringBuilder2.append(".txt").toString();
                String logfile_full_path1 = this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME + File.separator + logfile_full_name1;
                File logfile0 = new File(logfile_full_path0);
                File logfile1 = new File(logfile_full_path1);
                if (logfile0.exists() && logfile0.isFile()) {
                    logfile0.delete();
                }
                if (!logfile1.exists() || !logfile1.isFile()) continue;
                logfile1.renameTo(logfile0);
            }
            StringBuilder stringBuilder = new StringBuilder().append(this.JNNAME).append(String.valueOf(9));
            this.getClass();
            String logfile_full_name = stringBuilder.append(".txt").toString();
            String logfile_full_path = this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME + File.separator + logfile_full_name;
            return logfile_full_path;
        }
        catch (Exception e) {
            System.out.println("Journal.GetNetworkFileForWriting() -> invalid folder structure : " + e);
            this.dialog.AddLogRecord("Journal.GetNetworkFileForWriting() -> invalid folder structure : " + e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<String> GetJournalFilesRecords(Date d_start, Date d_end) {
        ArrayList<String> found_records = new ArrayList<String>();
        try {
            File folder = new File(this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME);
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles.length == 0) {
                String new_file_full_name = "journal_network-0.txt";
                String new_file_full_path = this.DEFAULT_JOURNAL_NETWORK_FOLDER_NAME + File.separator + new_file_full_name;
                return null;
            }
            File last_file = listOfFiles[listOfFiles.length - 1];
            long last_file_size = last_file.length();
            int i = 0;
            for (i = 0; i < listOfFiles.length; ++i) {
                File currentFile = listOfFiles[i];
                ArrayList<String> fileStrings = new ArrayList<String>();
                FileReader fileReader = new FileReader(currentFile.getPath());
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    String s;
                    while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                        fileStrings.add(s);
                    }
                    fileReader.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.GetJournalFilesRecords() -> journal file read : " + ex);
                    this.dialog.AddLogRecord("Journal.GetJournalFilesRecords() -> journal file read : " + ex);
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Journal.GetJournalFilesRecords() -> journal file close : " + ex);
                        this.dialog.AddLogRecord("Journal.GetJournalFilesRecords() -> journal file close : " + ex);
                    }
                    try {
                        fileReader.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Journal.GetJournalFilesRecords() -> journal file close : " + ex);
                        this.dialog.AddLogRecord("Journal.GetJournalFilesRecords() -> journal file close : " + ex);
                    }
                }
                for (String file_str : fileStrings) {
                    int file_date_end_index = 0;
                    for (i = 0; i < file_str.length(); ++i) {
                        if (file_str.charAt(i) != '=') continue;
                        file_date_end_index = i;
                        break;
                    }
                    String file_date_string = file_str.substring(0, file_date_end_index);
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                        Date file_date = sdf.parse(file_date_string);
                        if (file_date.after(d_start) && file_date.before(d_end)) {
                            found_records.add(file_str);
                        }
                        if (!file_date.after(d_end)) continue;
                        return found_records;
                    }
                    catch (Exception e) {
                        System.out.println("Journal.GetJournalFilesRecords() -> journal file date convertion invalid format : " + e);
                        this.dialog.AddLogRecord("Journal.GetJournalFilesRecords() -> journal file date convertion invalid format : " + e);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Journal.GetNetworkFileForWriting() -> invalid folder structure : " + e);
            this.dialog.AddLogRecord("Journal.GetNetworkFileForWriting() -> invalid folder structure : " + e);
        }
        return found_records;
    }

    public synchronized String GetCoreFileForWriting() {
        int maxIdx = -1;
        try {
            int i;
            File folder = new File(this.DEFAULT_JOURNAL_CORE_FOLDER_NAME);
            if (!folder.exists() || !folder.isDirectory()) {
                folder.mkdirs();
            }
            File[] listOfFiles = folder.listFiles();
            File last_file = null;
            for (i = 0; i < listOfFiles.length; ++i) {
                int Idx;
                if (!listOfFiles[i].isFile()) continue;
                String filename = listOfFiles[i].getName().toLowerCase();
                int n = filename.length();
                StringBuilder stringBuilder = new StringBuilder().append(this.JCNAME);
                this.getClass();
                if (n != stringBuilder.append(".txt").append(1).toString().length()) continue;
                this.getClass();
                filename = filename.replaceFirst(".txt", "");
                if (filename.length() != (this.JCNAME + 1).length() || !Character.isDigit(filename.charAt(this.JCNAME.length())) || (filename = filename.replaceFirst(this.JCNAME, "")).length() != 1 || !Character.isDigit(filename.charAt(0)) || maxIdx >= (Idx = Integer.parseInt(filename))) continue;
                maxIdx = Idx;
                last_file = listOfFiles[i];
            }
            if (maxIdx < 0 || last_file == null) {
                maxIdx = 0;
            } else if (last_file.length() >= this.max_file_size) {
                ++maxIdx;
            }
            if (maxIdx < 10) {
                StringBuilder stringBuilder = new StringBuilder().append(this.JCNAME).append(String.valueOf(maxIdx));
                this.getClass();
                String logfile_full_name = stringBuilder.append(".txt").toString();
                String logfile_full_path = this.DEFAULT_JOURNAL_CORE_FOLDER_NAME + File.separator + logfile_full_name;
                return logfile_full_path;
            }
            for (i = 1; i < 10; ++i) {
                StringBuilder stringBuilder = new StringBuilder().append(this.JCNAME).append(String.valueOf(i - 1));
                this.getClass();
                String logfile_full_name0 = stringBuilder.append(".txt").toString();
                String logfile_full_path0 = this.DEFAULT_JOURNAL_CORE_FOLDER_NAME + File.separator + logfile_full_name0;
                StringBuilder stringBuilder2 = new StringBuilder().append(this.JCNAME).append(String.valueOf(i));
                this.getClass();
                String logfile_full_name1 = stringBuilder2.append(".txt").toString();
                String logfile_full_path1 = this.DEFAULT_JOURNAL_CORE_FOLDER_NAME + File.separator + logfile_full_name1;
                File logfile0 = new File(logfile_full_path0);
                File logfile1 = new File(logfile_full_path1);
                if (logfile0.exists() && logfile0.isFile()) {
                    logfile0.delete();
                }
                if (!logfile1.exists() || !logfile1.isFile()) continue;
                logfile1.renameTo(logfile0);
            }
            StringBuilder stringBuilder = new StringBuilder().append(this.JCNAME).append(String.valueOf(9));
            this.getClass();
            String logfile_full_name = stringBuilder.append(".txt").toString();
            String logfile_full_path = this.DEFAULT_JOURNAL_CORE_FOLDER_NAME + File.separator + logfile_full_name;
            return logfile_full_path;
        }
        catch (Exception e) {
            System.out.println("Journal.GetCoreFileForWriting() -> invalid folder structure : " + e);
            this.dialog.AddLogRecord("Journal.GetCoreFileForWriting() -> invalid folder structure : " + e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void AddCoreJournalRecord(String line) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.GetCoreFileForWriting(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            try {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            catch (IOException ex) {
                System.out.println("Journal.AddRecords() -> journal file write : " + ex);
                this.dialog.AddLogRecord("Journal.AddRecords() -> journal file write : " + ex);
            }
            finally {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Journal.AddRecords() -> journal file open : " + e);
            this.dialog.AddLogRecord("Journal.AddRecords() -> journal file open : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ClearJournal(String type) {
        try {
            BufferedWriter bufferedWriter;
            FileOutputStream fileOutputStream;
            if (type.equals("CORE")) {
                fileOutputStream = new FileOutputStream(this.DEFAULT_CORE_JOURNAL_FILENAME);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            } else {
                fileOutputStream = new FileOutputStream(this.DEFAULT_NETWORK_JOURNAL_FILENAME);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            }
            try {
                bufferedWriter.write("");
                bufferedWriter.flush();
            }
            catch (IOException ex) {
                System.out.println("Journal.AddRecords() -> journal file write : " + ex);
                this.dialog.AddLogRecord("Journal.AddRecords() -> journal file write : " + ex);
            }
            finally {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.AddRecords() -> journal file close : " + ex);
                    this.dialog.AddLogRecord("Journal.AddRecords() -> journal file close : " + ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Journal.AddRecords() -> journal file open : " + e);
            this.dialog.AddLogRecord("Journal.AddRecords() -> journal file open : " + e);
        }
    }

    public synchronized void GetRecords(Date d_start, Date d_end, Gui gui) {
        try {
            ArrayList<String> found_Strings = this.GetJournalFilesRecords(d_start, d_end);
            try {
                for (String found_line : found_Strings) {
                    int j;
                    byte[] byte_array;
                    String field_string;
                    char ch;
                    int i = 0;
                    boolean begin_record_index = false;
                    int end_record_index = 0;
                    int full_message_length = 0;
                    short year = 0;
                    short month = 0;
                    short day = 0;
                    boolean year_b1 = false;
                    boolean year_b2 = false;
                    short hours = 0;
                    short minutes = 0;
                    short seconds = 0;
                    short event_type = 0;
                    short alarm_name_length = 0;
                    short[] alarm_name = new short[]{};
                    short alarm_index = 0;
                    short ip_b1 = 0;
                    short ip_b2 = 0;
                    short ip_b3 = 0;
                    short ip_b4 = 0;
                    short rack_name_length = 0;
                    short[] rack_name = new short[]{};
                    short slot = 0;
                    short card_code_b1 = 0;
                    short card_code_b2 = 0;
                    short card_code_b3 = 0;
                    short card_code_b4 = 0;
                    short card_name_length = 0;
                    short[] card_name = new short[]{};
                    for (i = 0; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ' ') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 1;
                        try {
                            String[] date_string_array = field_string.split("-");
                            year = Short.parseShort(date_string_array[0], 10);
                            month = Short.parseShort(date_string_array[1], 10);
                            day = Short.parseShort(date_string_array[2], 10);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line date convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line date convertion invalid format : " + e);
                        }
                        break;
                    }
                    full_message_length += 4;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != '=') continue;
                        field_string = found_line.substring(end_record_index, i - 1);
                        end_record_index = i + 1;
                        try {
                            String[] time_string_array = field_string.split(":");
                            hours = (short)Integer.parseInt(time_string_array[0], 10);
                            minutes = (short)Integer.parseInt(time_string_array[1], 10);
                            seconds = (short)Integer.parseInt(time_string_array[2], 10);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line time convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line time convertion invalid format : " + e);
                        }
                        break;
                    }
                    full_message_length += 3;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        field_string = field_string.replace(" ", "");
                        end_record_index = i + 2;
                        try {
                            if (field_string.equals("ALARM_ON")) {
                                event_type = 1;
                            }
                            if (field_string.equals("ALARM_OFF")) {
                                event_type = 2;
                            }
                            if (field_string.equals("RACK_LOST")) {
                                event_type = 3;
                            }
                            if (field_string.equals("RACK_FOUND")) {
                                event_type = 4;
                            }
                            if (field_string.equals("CARD_LOST")) {
                                event_type = 3;
                            }
                            if (field_string.equals("CARD_FOUND")) {
                                event_type = 4;
                            }
                            if (event_type != 0) break;
                            System.out.println("Journal.GetRecords() -> journal file line event_type convertion invalid format : " + field_string);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line event_type convertion invalid format : " + field_string);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line event_type convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line event_type convertion invalid format : " + e);
                        }
                        break;
                    }
                    ++full_message_length;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 2;
                        try {
                            byte_array = field_string.getBytes();
                            alarm_name_length = (short)byte_array.length;
                            ++full_message_length;
                            alarm_name = new short[byte_array.length];
                            full_message_length += byte_array.length;
                            j = 0;
                            for (j = 0; j < byte_array.length; ++j) {
                                alarm_name[j] = byte_array[j];
                            }
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line alarm_name convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line alarm_name convertion invalid format : " + e);
                            break;
                        }
                    }
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 2;
                        try {
                            alarm_index = (short)(Integer.parseInt(field_string) & 0xFF);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line alarm_name convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line alarm_name convertion invalid format : " + e);
                        }
                        break;
                    }
                    ++full_message_length;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 2;
                        try {
                            String[] ip_string_array = field_string.split("\\.");
                            ip_b1 = (short)Integer.parseInt(ip_string_array[0], 10);
                            ip_b2 = (short)Integer.parseInt(ip_string_array[1], 10);
                            ip_b3 = (short)Integer.parseInt(ip_string_array[2], 10);
                            ip_b4 = (short)Integer.parseInt(ip_string_array[3], 10);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line ip-address convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal file line ip-address convertion invalid format : " + e);
                        }
                        break;
                    }
                    full_message_length += 4;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 2;
                        try {
                            byte_array = field_string.getBytes();
                            rack_name_length = (short)byte_array.length;
                            ++full_message_length;
                            rack_name = new short[byte_array.length];
                            full_message_length += byte_array.length;
                            j = 0;
                            for (j = 0; j < byte_array.length; ++j) {
                                rack_name[j] = byte_array[j];
                            }
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line alarm_name convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line alarm_name convertion invalid format : " + e);
                            break;
                        }
                    }
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        field_string.replace(" ", "");
                        end_record_index = i + 2;
                        try {
                            slot = (short)Integer.parseInt(field_string, 10);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line slot_number convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line slot_number convertion invalid format : " + e);
                        }
                        break;
                    }
                    ++full_message_length;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        field_string.replace(" ", "");
                        end_record_index = i + 2;
                        try {
                            short n_card_code = (short)Integer.parseInt(field_string, 10);
                            card_code_b1 = (short)(n_card_code >> 24);
                            card_code_b2 = (short)(n_card_code >> 16 & 0xFF);
                            card_code_b3 = (short)(n_card_code >> 8 & 0xFF);
                            card_code_b4 = (short)(n_card_code & 0xFF);
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line slot_number convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line slot_number convertion invalid format : " + e);
                        }
                        break;
                    }
                    full_message_length += 4;
                    for (i = end_record_index; i < found_line.length(); ++i) {
                        ch = found_line.charAt(i);
                        if (ch != ';') continue;
                        field_string = found_line.substring(end_record_index, i);
                        end_record_index = i + 2;
                        try {
                            byte[] byte_array2 = field_string.getBytes();
                            card_name_length = (short)byte_array2.length;
                            ++full_message_length;
                            card_name = new short[byte_array2.length];
                            full_message_length += byte_array2.length;
                            j = 0;
                            for (j = 0; j < byte_array2.length; ++j) {
                                card_name[j] = byte_array2[j];
                            }
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("Journal.GetRecords() -> journal file line alarm_name convertion invalid format : " + e);
                            this.dialog.AddLogRecord("Journal.GetRecords() -> journal line alarm_name convertion invalid format : " + e);
                            break;
                        }
                    }
                    boolean ppp = false;
                    int message_index = 0;
                    Message mess = new Message();
                    mess.getClass();
                    mess.SetToHeader(2, gui.ip[0]);
                    mess.getClass();
                    mess.SetToHeader(3, gui.ip[1]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP3, gui.ip[2]);
                    mess.SetToHeader(mess.POS_MESSAGE_IP4, gui.ip[3]);
                    mess.SetToHeader(mess.POS_SIZE_OF_DATA, (short)(full_message_length + 1));
                    mess.SetToBody(0, (short)full_message_length);
                    mess.SetToBody(1, (short)140);
                    mess.SetToBody(2, day);
                    mess.SetToBody(3, month);
                    mess.SetToBody(4, year);
                    mess.SetToBody(5, hours);
                    mess.SetToBody(6, minutes);
                    mess.SetToBody(7, seconds);
                    mess.SetToBody(8, event_type);
                    mess.SetToBody(9, alarm_index);
                    message_index = 9;
                    mess.SetToBody(message_index + 1, alarm_name_length);
                    ++message_index;
                    for (i = 0; i < alarm_name_length; ++i) {
                        mess.SetToBody(message_index + 1 + i, alarm_name[i]);
                    }
                    mess.SetToBody((message_index += alarm_name_length) + 1, ip_b1);
                    mess.SetToBody(message_index + 2, ip_b2);
                    mess.SetToBody(message_index + 3, ip_b3);
                    mess.SetToBody(message_index + 4, ip_b4);
                    mess.SetToBody((message_index += 4) + 1, rack_name_length);
                    ++message_index;
                    for (i = 0; i < rack_name_length; ++i) {
                        mess.SetToBody(message_index + 1 + i, rack_name[i]);
                    }
                    mess.SetToBody((message_index += rack_name_length) + 1, slot);
                    mess.SetToBody(++message_index + 1, card_code_b1);
                    mess.SetToBody(message_index + 2, card_code_b2);
                    mess.SetToBody(message_index + 3, card_code_b3);
                    mess.SetToBody(message_index + 4, card_code_b4);
                    mess.SetToBody((message_index += 4) + 1, card_name_length);
                    ++message_index;
                    for (i = 0; i < card_name_length; ++i) {
                        mess.SetToBody(message_index + 1 + i, card_name[i]);
                    }
                    message_index += card_name_length;
                    if (this.socket_tcp == null) continue;
                    this.socket_tcp.Write(mess);
                    this.dialog.AddLogRecord("Journal.GetRecords() -> sending journal record to: [" + gui.ip_str + "] " + found_line);
                    this.dialog.AddLogRecord("Journal.GetRecords() -> sending journal record to: [" + gui.ip_str + "] " + ": MESSAGE = " + mess.toString());
                    System.out.println("Journal.GetRecords() -> sending journal record to: [" + gui.ip_str + "] " + found_line);
                    System.out.println("Journal.GetRecords() -> sending journal record to: [" + gui.ip_str + "] " + ": MESSAGE = " + mess.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Journal.GetRecords() -> record parsing : " + e);
                this.dialog.AddLogRecord("Journal.GetRecords() -> record parsing : " + e);
            }
        }
        catch (Exception e) {
            System.out.println("Journal.GetRecords() -> journal file open : " + e);
            this.dialog.AddLogRecord("Journal.GetRecords() -> journal file open : " + e);
        }
    }

    public synchronized void GetAllJournal(ArrayList<String> records_array) {
    }
}

