/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.snmp4j.smi.IpAddress;

public class MainClass
extends Thread
implements ObserverObject {
    public final int DEFAULT_GUI_CHECK_TIMEOUT = 500;
    private static final Socket_TCP socketTCP = Socket_TCP.getInstance();
    private static final Socket_UDP socketUDP = Socket_UDP.getInstance();
    MainDialog dialog;
    Journal journal;
    ArrayList<Gui> gui_list = new ArrayList();
    ProflexRackManager rackManager;
    public TrapSocket trapSocket;
    final boolean show_add_delete_gui_messages = true;
    final boolean show_delete_rack_from_gui_messages = false;
    Timer timer = new Timer();
    TimerTask timerTask = new MyTask();

    public MainClass(MainDialog dlg, Journal journal) {
        try {
            this.dialog = dlg;
            this.journal = this.dialog.journal;
            System.out.println("Starting MainClass...");
            this.dialog.AddLogRecord("Starting MainClass...");
            this.trapSocket = new TrapSocket(this.dialog);
            this.trapSocket.Start();
            this.dialog = dlg;
            this.rackManager = new ProflexRackManager(socketUDP, this.trapSocket, this.dialog, this);
            socketTCP.Start();
            MainClass.socketTCP.dialog = this.dialog;
            socketTCP.AddObserver(this);
            journal.SetSocketTCP(socketTCP);
            socketUDP.Start();
            socketUDP.AddObserver(this);
            this.gui_list.clear();
            this.setDaemon(true);
            this.setPriority(5);
            this.start();
            this.getClass();
            this.timer.schedule(this.timerTask, 0L, 500L);
        }
        catch (Exception e) {
            System.out.println("MainClass init error: " + e);
            this.dialog.AddLogRecord("MainClass init error: " + e);
        }
    }

    @Override
    public void run() {
    }

    @Override
    public synchronized void ProcessEvent() {
        System.out.println("Socket_TCP event has reached!");
        this.dialog.AddLogRecord("Socket_TCP event has reached!");
    }

    @Override
    public synchronized void ProcessEvent(String str) {
        System.out.println(str);
        this.dialog.AddLogRecord(str);
    }

    @Override
    public synchronized void ProcessEvent(Message message) {
        message.getClass();
        short message_type = message.GetFromHeader(1);
        switch (message_type) {
            case 1: {
                if (message.GetFromBody(1) != 60) {
                    this.Process_GUIMessage(message);
                    break;
                }
                this.Process_GUIMessage(message);
                break;
            }
            case 2: {
                this.Process_RackMessage(message);
                break;
            }
            case 3: {
                this.Kill_GUI(message);
                break;
            }
        }
    }

    public void SendTrap(Message message) {
        try {
            int[] data = new int[8];
            data[0] = 8;
            for (int i = 0; i < 7; ++i) {
                data[i + 1] = message.GetFromBody(i + 2) & 0xFF;
            }
            this.trapSocket.SendTrap(data);
            System.out.println("SNMP trap sent to " + this.trapSocket.destAddress.toString());
            this.dialog.AddLogRecord("SNMP trap sent to " + this.trapSocket.destAddress.toString());
        }
        catch (Exception e) {
            System.out.println("MainClass->SendTrap(): " + e);
            this.dialog.AddLogRecord("MainClass->SendTrap(): " + e);
        }
    }

    public void Process_GUIMessage(Message message) {
        try {
            boolean b_found = false;
            short[] message_ip = message.getIP();
            if (this.gui_list.size() > 0) {
                for (Gui gui : this.gui_list) {
                    short[] gui_ip = gui.GetIP();
                    if (!Arrays.equals(message_ip, gui_ip)) continue;
                    gui.ProcessGUI_Message(message);
                    b_found = true;
                    break;
                }
            }
            if (!b_found) {
                Gui gui = new Gui(this.dialog, socketTCP, message_ip[0], message_ip[1], message_ip[2], message_ip[3], message.GetFromHeader(message.POS_MESSAGE_PORT));
                this.gui_list.add(gui);
                this.getClass();
                String gui_new_ip = String.valueOf(gui.ip[0]) + "." + String.valueOf(gui.ip[1]) + "." + String.valueOf(gui.ip[2]) + "." + String.valueOf(gui.ip[3]);
                String str_full = "MainClass->Process_GUIMessage: new GUI added (IP =  " + gui_new_ip + "); ";
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
                str_full = "MainClass->Process_GUIMessage gui_list =  ";
                for (Gui gui_list : this.gui_list) {
                    gui_new_ip = String.valueOf(gui_list.ip[0]) + "." + String.valueOf(gui_list.ip[1]) + "." + String.valueOf(gui_list.ip[2]) + "." + String.valueOf(gui_list.ip[3]);
                    str_full = str_full + gui_new_ip + ", ";
                }
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
                this.rackManager.RegisterGuiInRacks(gui);
                gui.ProcessGUI_Message(message);
            }
        }
        catch (Exception e) {
            System.out.println("MainClass->Process_GUIMessage(): " + e);
            this.dialog.AddLogRecord("MainClass->Process_GUIMessage(): " + e);
        }
    }

    public void Process_RackMessage(Message message) {
        try {
            try {
                this.rackManager.ProcessRackMessage(message);
            }
            catch (Exception e) {
                System.out.println("MainClass->Process_RackMessage()->this.rackManager.ProcessRackMessage(message): " + e);
                this.dialog.AddLogRecord("MainClass->Process_RackMessage()->this.rackManager.ProcessRackMessage(message): " + e);
            }
            try {
                block12: for (Gui gui : this.gui_list) {
                    for (IpAddress ip_gui : gui.resolved_rack_list) {
                        IpAddress message_addr = message.getIP_IpAddress();
                        if (!message_addr.equals(ip_gui)) continue;
                        short[] addr_sh = message.getIP();
                        ProflexRack rack = this.rackManager.getRack(addr_sh);
                        if (rack == null) {
                            return;
                        }
                        boolean b_found = false;
                        try {
                            for (ProflexRack list_rack : gui.observers_racks_list) {
                                IpAddress list_rack_ip = list_rack.getIP_IpAddress();
                                if (!list_rack_ip.equals(ip_gui)) continue;
                                b_found = true;
                                break;
                            }
                        }
                        catch (Exception e) {
                            System.out.println("MainClass->Process_RackMessage() find rack in GUI resolved rack list: " + e);
                            this.dialog.AddLogRecord("MainClass->Process_RackMessage() find rack in GUI resolved rack list: " + e);
                        }
                        try {
                            if (b_found) continue block12;
                            gui.AddObserver(rack);
                            b_found = false;
                            for (Gui list_gui : rack.observers_guis_list) {
                                short[] gui_ip;
                                short[] list_gui_ip = list_gui.GetIP();
                                if (!Arrays.equals(list_gui_ip, gui_ip = gui.GetIP())) continue;
                                b_found = true;
                                break;
                            }
                            if (b_found) continue block12;
                            try {
                                rack.AddObserver(gui);
                            }
                            catch (Exception e) {
                                System.out.println("MainClass->Process_RackMessage(): rack.AddObserver(gui): " + e);
                                this.dialog.AddLogRecord("MainClass->Process_RackMessage(): rack.AddObserver(gui): " + e);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("MainClass->Process_RackMessage() nof found rack in GUI resolved rack list: " + e);
                            this.dialog.AddLogRecord("MainClass->Process_RackMessage() nof found rack in GUI resolved rack list: " + e);
                        }
                        continue block12;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("MainClass->Process_RackMessage(): " + e);
                this.dialog.AddLogRecord("MainClass->Process_RackMessage(): " + e);
            }
        }
        catch (Exception e) {
            System.out.println("MainClass->Process_RackMessage(): " + e);
            this.dialog.AddLogRecord("MainClass->Process_RackMessage(): " + e);
        }
    }

    public void Kill_GUI(Message message) {
        try {
            for (Gui gui : this.gui_list) {
                short[] message_ip = message.getIP();
                short[] gui_ip = gui.GetIP();
                if (!Arrays.equals(gui_ip, message_ip)) continue;
                gui.b_gui_ready = false;
                String client_info = " (IP = " + String.valueOf(message_ip[0]) + "." + String.valueOf(message_ip[1]) + "." + String.valueOf(message_ip[2]) + "." + String.valueOf(message_ip[3]) + ") ";
                String str_mess = "MainClass.Kill_GUI(): [BY_SOCKET_READ_ERROR] " + client_info;
                System.out.println(str_mess);
                this.getClass();
                this.dialog.AddLogRecord(str_mess);
                this.rackManager.RemoveGUI(gui);
                this.gui_list.remove(gui);
                this.getClass();
                String gui_new_ip = String.valueOf(gui.ip[0]) + "." + String.valueOf(gui.ip[1]) + "." + String.valueOf(gui.ip[2]) + "." + String.valueOf(gui.ip[3]);
                String str_full = "MainClass->Kill_GUI(): [BY_SOCKET_READ_ERROR] GUI removed (IP =  " + gui_new_ip + "); ";
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
                str_full = "MainClass->Kill_GUI(): [BY_SOCKET_READ_ERROR] gui_list =  ";
                for (Gui gui_list : this.gui_list) {
                    gui_new_ip = String.valueOf(gui_list.ip[0]) + "." + String.valueOf(gui_list.ip[1]) + "." + String.valueOf(gui_list.ip[2]) + "." + String.valueOf(gui_list.ip[3]);
                    str_full = str_full + gui_new_ip + ", ";
                }
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
                break;
            }
        }
        catch (Exception e) {
            System.out.println("MainClass->Kill_GUI(): [BY_SOCKET_READ_ERROR] " + e);
            this.dialog.AddLogRecord("MainClass->Kill_GUI(): [BY_SOCKET_READ_ERROR] " + e);
        }
    }

    public synchronized void Kill_GUI(Gui gui) {
        try {
            gui.b_gui_ready = false;
            short[] gui_ip = gui.GetIP();
            String client_info = " (IP = " + String.valueOf(gui_ip[0]) + "." + String.valueOf(gui_ip[1]) + "." + String.valueOf(gui_ip[2]) + "." + String.valueOf(gui_ip[3]) + ") ";
            String str_mess = "MainClass.Kill_GUI(): [BY_TIMEOUT]  " + client_info;
            this.getClass();
            this.dialog.AddLogRecord(str_mess);
            System.out.println(str_mess);
            this.rackManager.RemoveGUI(gui);
            this.gui_list.remove(gui);
            gui.socket.CloseConnectionByTimeout(gui.ip_str);
            this.getClass();
            String gui_new_ip = String.valueOf(gui.ip[0]) + "." + String.valueOf(gui.ip[1]) + "." + String.valueOf(gui.ip[2]) + "." + String.valueOf(gui.ip[3]);
            String str_full = "MainClass->Kill_GUI(): [BY_TIMEOUT] GUI removed (IP =  " + gui_new_ip + "); ";
            System.out.println(str_full);
            this.dialog.AddLogRecord(str_full);
            str_full = "MainClass->Kill_GUI(): [BY_TIMEOUT] gui_list =  ";
            for (Gui gui_list : this.gui_list) {
                gui_new_ip = String.valueOf(gui_list.ip[0]) + "." + String.valueOf(gui_list.ip[1]) + "." + String.valueOf(gui_list.ip[2]) + "." + String.valueOf(gui_list.ip[3]);
                str_full = str_full + gui_new_ip + ", ";
            }
            System.out.println(str_full);
            this.dialog.AddLogRecord(str_full);
        }
        catch (Exception e) {
            System.out.println("MainClass->Kill_GUI(): [BY_TIMEOUT] " + e);
            this.dialog.AddLogRecord("MainClass->Kill_GUI(): [BY_TIMEOUT] " + e);
        }
    }

    public class MyTask
    extends TimerTask {
        @Override
        public void run() {
            if (MainClass.this.gui_list.size() > 0) {
                long time_now = System.currentTimeMillis();
                long gui_timestamp = 0L;
                ArrayList<Gui> dead_gui_list = new ArrayList<Gui>();
                for (Gui gui : MainClass.this.gui_list) {
                    String str_full;
                    long diff;
                    gui_timestamp = gui.timestamp;
                    if (time_now - gui_timestamp > gui.DEFAULT_TIMEOUT) {
                        diff = time_now - gui_timestamp;
                        str_full = "TIMER: GUI timeout check: GUI LOST (GUI = " + gui.ip_str + " timeout = " + diff + ")";
                        if (gui.show_pulse_messages) {
                            System.out.println(str_full);
                            MainClass.this.dialog.AddLogRecord(str_full);
                        }
                        dead_gui_list.add(gui);
                        continue;
                    }
                    diff = time_now - gui_timestamp;
                    str_full = "TIMER: GUI timeout check: GUI OK (GUI = " + gui.ip_str + " timeout = " + diff + ")";
                    if (!gui.show_pulse_messages) continue;
                    System.out.println(str_full);
                    MainClass.this.dialog.AddLogRecord(str_full);
                }
                for (Gui gui : dead_gui_list) {
                    MainClass.this.Kill_GUI(gui);
                }
            }
        }
    }
}

