/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.snmp4j.smi.IpAddress;

public class ProflexCard
extends RemoteObject_old
implements ConfiguredObject {
    MainDialog dialog;
    ProflexRack rack;
    IpAddress ipAddress;
    int code;
    short slot;
    String name = "";
    final String DEFAULT_MONITORING_SETTINGS_FILENAME = "core_monitoring_settings.conf";
    boolean bCardLoadControlsTable = false;
    ArrayList<CoreSetting> settings = new ArrayList();
    public ArrayList<String> control_table_list = new ArrayList();
    public short[] state_table;
    public short state_table_length = 0;
    public ArrayList<ProflexSetting> proflexSettings = new ArrayList();
    boolean have_default_alarms_file = false;
    boolean show_load_tables_messages = false;

    public ProflexCard(MainDialog dialog, ProflexRack rack, IpAddress ip, int code, boolean b_get_table_from_card, short slot) {
        this.dialog = dialog;
        this.rack = rack;
        this.ipAddress = ip;
        this.bCardLoadControlsTable = b_get_table_from_card;
        this.code = code;
        this.slot = slot;
        this.control_table_list.clear();
        this.settings.add(new CoreSetting("card_show_load_tables_messages"));
        this.GetObjectConfig();
        this.show_load_tables_messages = this.settings.get(0).getValue_bool();
        this.LoadControlsTable();
        File folder = new File("DEFAULT_BLOCKS_ALARMS");
        File[] listOfFiles = folder.listFiles();
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            String filename = fileEntry.getName();
            int dot_pos = filename.indexOf(46);
            String filename_no_ext = filename.substring(0, dot_pos - 2);
            long block_code = this.code;
            if (block_code == 0L) {
                return;
            }
            int k = 0;
            String codestr = "F";
            String str_val_dec = Long.toHexString(block_code);
            if ((str_val_dec = str_val_dec.toUpperCase()).length() > 8) {
                return;
            }
            if (str_val_dec.length() < 8) {
                for (k = 0; k < 7 - str_val_dec.length(); ++k) {
                    codestr = codestr + "0";
                }
                codestr = codestr + str_val_dec;
            }
            if (codestr.length() < 3) {
                boolean ppp = false;
            }
            if (!filename_no_ext.equals(codestr)) continue;
            this.have_default_alarms_file = true;
            break;
        }
        this.RemoveOldMonitoringRecords();
        this.LoadMonitoringSettings();
        this.state_table = new short[256];
    }

    @Override
    public void GetObjectConfig() {
        try {
            for (CoreSetting s : this.settings) {
                s.GetSetting();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard.GetObjectConfig(): " + e);
            this.dialog.AddLogRecord("ProflexCard.GetObjectConfig(): " + e);
        }
    }

    public void LoadControlsTable() {
        try {
            String s;
            long block_code = this.code;
            if (block_code == 0L) {
                return;
            }
            int k = 0;
            String filename = "F";
            String str_val_dec = Long.toHexString(block_code);
            if ((str_val_dec = str_val_dec.toUpperCase()).length() > 8) {
                return;
            }
            if (str_val_dec.length() < 8) {
                for (k = 0; k < 7 - str_val_dec.length(); ++k) {
                    filename = filename + "0";
                }
                filename = filename + str_val_dec + ".str";
            }
            if (filename.length() < 7) {
                boolean ppp = false;
            }
            FileInputStream fis = new FileInputStream("BLOCKS/" + filename);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "Cp1251"));
            String s_full = "";
            while ((s = br.readLine()) != null && s.length() > 0) {
                this.control_table_list.add(s);
                s_full = s_full + s;
                s_full = s_full + ";";
            }
            fis.close();
            String rightString = new String(s_full.getBytes(), "Cp1251");
            byte[] str_bytes = s_full.getBytes("Cp1251");
            boolean ppp = false;
            try {
                String str_all = this.control_table_list.get(4);
                if (this.slot == 14) {
                    boolean pppp = false;
                }
                str_all.replace(" ", "");
                for (int i = 0; i < str_all.length(); ++i) {
                    if (str_all.charAt(i) != '=') continue;
                    int begin_pos = i;
                    String str_table_only = str_all.substring(begin_pos + 1);
                    String[] str_settings_arr = str_table_only.split(";");
                    if (str_settings_arr[0].equals("none") || str_settings_arr[0].equals("NONE")) {
                        this.bCardLoadControlsTable = true;
                    }
                    this.proflexSettings.add(0, new ProflexSetting(this.dialog, this.rack, this, this.ipAddress, this.slot, this.proflexSettings.size(), "STATUS_LINE", this.code));
                    for (int j = 0; j < str_settings_arr.length; ++j) {
                        this.proflexSettings.add(j + 1, new ProflexSetting(this.dialog, this.rack, this, this.ipAddress, this.slot, j + 1, str_settings_arr[j], this.code));
                    }
                    break;
                }
                this.state_table_length = (short)(this.proflexSettings.size() * 2 - 1);
                if (this.proflexSettings.size() == 0) {
                    this.state_table_length = 0;
                    System.out.println("ProflexCard: LoadControlsTable(): invalid settings list length");
                    this.dialog.AddLogRecord("ProflexCard: LoadControlsTable(): invalid settings list length");
                }
            }
            catch (Exception e) {
                System.out.println("ProflexCard: LoadControlsTable() -> create settings: " + e);
                this.dialog.AddLogRecord("ProflexCard: LoadControlsTable() -> create settings:: " + e);
            }
            String clear_name = this.control_table_list.get(1);
            int equals_index = clear_name.indexOf(61);
            this.name = clear_name = clear_name.substring(equals_index + 1);
            if (this.bCardLoadControlsTable) {
                // empty if block
            }
            if (this.show_load_tables_messages) {
                String str_mess = "CARD: code = " + this.code + ": LoadControlsTable(): ";
                for (String control_table_string : this.control_table_list) {
                    str_mess = str_mess + control_table_string;
                    str_mess = str_mess + "\n\r";
                }
                System.out.println(str_mess);
                this.dialog.AddLogRecord(str_mess);
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard: LoadControlsTable(): " + e);
            this.dialog.AddLogRecord("ProflexCard: LoadControlsTable(): " + e);
        }
    }

    public void ProcessControlsTable(String controls_table_str) {
        try {
            try {
                this.control_table_list.set(4, "CONTROL_TABLE=" + controls_table_str);
                String str_all = controls_table_str;
                str_all.replace(" ", "");
                String[] str_settings_arr = str_all.split(";");
                for (int j = 0; j < str_settings_arr.length; ++j) {
                    this.proflexSettings.add(j + 1, new ProflexSetting(this.dialog, this.rack, this, this.ipAddress, this.slot, j + 1, str_settings_arr[j], this.code));
                }
                this.state_table_length = (short)(this.proflexSettings.size() * 2 - 1);
                if (this.proflexSettings.size() == 0) {
                    this.state_table_length = 0;
                    System.out.println("ProflexCard: ProcessControlsTable(): invalid settings list length");
                    this.dialog.AddLogRecord("ProflexCard: ProcessControlsTable(): invalid settings list length");
                }
            }
            catch (Exception e) {
                System.out.println("ProflexCard: ProcessControlsTable() -> create settings: " + e);
                this.dialog.AddLogRecord("ProflexCard: ProcessControlsTable() -> create settings:: " + e);
            }
            if (this.show_load_tables_messages) {
                String str_mess = "CARD: code = " + this.code + ": ProcessControlsTable(): ";
                for (String control_table_string : this.control_table_list) {
                    str_mess = str_mess + control_table_string;
                    str_mess = str_mess + "\n\r";
                }
                System.out.println(str_mess);
                this.dialog.AddLogRecord(str_mess);
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard: ProcessControlsTable(): " + e);
            this.dialog.AddLogRecord("ProflexCard: ProcessControlsTable(): " + e);
        }
    }

    public void LoadMonitoringSettings() {
        try {
            int j = 0;
            for (j = 0; j < this.proflexSettings.size(); ++j) {
                this.proflexSettings.get(j).LoadSettings();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard: LoadMonitoringSettings(): " + e);
            this.dialog.AddLogRecord("ProflexCard: LoadMonitoringSettings(): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void RemoveOldMonitoringRecords() {
        if (this.code == 0) {
            return;
        }
        if (!this.have_default_alarms_file) {
            boolean ppp = false;
            return;
        }
        boolean ppp = false;
        String card_ip_str = this.ipAddress.toString();
        ArrayList<String> fileStrings = new ArrayList<String>();
        try {
            String s;
            FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    fileStrings.add(s);
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file read: " + e);
                this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file read : " + e);
            }
            int i = 0;
            int j = 0;
            int k = 0;
            boolean is_other_records_for_rack = false;
            int found_ip_line_index = 0;
            try {
                for (i = 0; i < fileStrings.size(); ++i) {
                    String file_ip;
                    s = (String)fileStrings.get(i);
                    if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']' || !(file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1)).equals(card_ip_str)) continue;
                    found_ip_line_index = i;
                    try {
                        String s_block;
                        for (j = i + 1; j < fileStrings.size() && ((s_block = (String)fileStrings.get(j)).charAt(0) != '[' || s_block.charAt(s_block.length() - 1) != ']'); ++j) {
                            s_block = s_block.replaceAll(" ", "");
                            String[] splitted = s_block.split(";");
                            int[] table = new int[10];
                            for (k = 0; k < 10; ++k) {
                                table[k] = Integer.parseInt(splitted[k]);
                                if (splitted[k] != "0") continue;
                                table[k] = 0;
                            }
                            if (table[0] == this.slot && table[9] != this.code) {
                                System.out.println("GUI.RemoveOldMonitoringRecords() -> removing (slot = ok, code mismatch): " + (String)fileStrings.get(j));
                                this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> removing (slot = ok, code mismatch): " + (String)fileStrings.get(j));
                                fileStrings.remove(j);
                                --j;
                                continue;
                            }
                            is_other_records_for_rack = true;
                        }
                        if (!is_other_records_for_rack) {
                            fileStrings.remove(found_ip_line_index);
                            System.out.println("GUI.RemoveOldMonitoringRecords() -> removing block (no more records): " + this.ipAddress.toString());
                            this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> removing block (no more records): " + this.ipAddress.toString());
                        }
                    }
                    catch (Exception e) {
                        System.out.println("GUI.RemoveOldMonitoringRecords() -> file strings record searching: " + e);
                        this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> file strings record searching: " + e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("GUI.RemoveOldMonitoringRecords() -> file strings block searching: " + e);
                this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> file strings block searching: " + e);
            }
        }
        catch (Exception e) {
            System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file read: " + e);
            this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file read : " + e);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1251"));
            try {
                int i = 0;
                for (i = 0; i < fileStrings.size(); ++i) {
                    String line = (String)fileStrings.get(i);
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (IOException ex) {
                System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file write : " + ex);
                this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file write : " + ex);
            }
            finally {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file close : " + ex);
                    this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file close : " + ex);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file close : " + ex);
                    this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file close : " + ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("GUI.RemoveOldMonitoringRecords() -> monitoring file open : " + e);
            this.dialog.AddLogRecord("GUI.RemoveOldMonitoringRecords() -> monitoring file open : " + e);
        }
    }

    public void SetStateTable(short[] table, int length) {
        if (this.proflexSettings.size() == 0) {
            System.out.println("ProflexCard: SetStateTable(): invalid settings list length");
            this.dialog.AddLogRecord("ProflexCard: SetStateTable(): invalid settings list length");
            return;
        }
        if (this.state_table_length != length) {
            System.out.println("ProflexCard: SetStateTable(): invalid table length");
            this.dialog.AddLogRecord("ProflexCard: SetStateTable(): invalid table length");
        } else {
            try {
                short s1;
                int i = 0;
                short[] table_short = new short[this.proflexSettings.size()];
                for (i = 0; i < this.proflexSettings.size() - 1; ++i) {
                    s1 = table[i * 2 + 1];
                    table_short[i + 1] = (short)(table_short[i + 1] | (s1 & 0xFF) << 8);
                    short s2 = table[i * 2];
                    table_short[i + 1] = (short)(table_short[i + 1] | s2 & 0xFF);
                }
                s1 = table[this.state_table_length - 1];
                table_short[0] = (short)(table_short[0] | s1 & 0xFF);
                for (i = 1; i < this.proflexSettings.size(); ++i) {
                    this.proflexSettings.get(i).setValue(table_short[i]);
                }
                this.proflexSettings.get(0).setValue(table_short[0]);
                boolean ppp = false;
            }
            catch (Exception e) {
                System.out.println("ProflexCard: SetStateTable(): " + e);
                this.dialog.AddLogRecord("ProflexCard: SetStateTable(): " + e);
            }
        }
    }

    public void CheckMonitoringParams() {
        try {
            for (ProflexSetting setting : this.proflexSettings) {
                setting.CheckMonitoringParams();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard: CheckMonitoringParams(): " + e);
            this.dialog.AddLogRecord("ProflexCard: CheckMonitoringParams(): " + e);
        }
    }

    public void SendGUI_AllCurrentAlarms() {
        try {
            for (ProflexSetting setting : this.proflexSettings) {
                setting.SendGUI_CurrentAlarmState();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexCard: SendGUI_AllCurrentAlarms(): " + e);
            this.dialog.AddLogRecord("ProflexCard: SendGUI_AllCurrentAlarms(): " + e);
        }
    }
}

