/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.snmp4j.smi.IpAddress;

public class ProflexRack
extends RemoteObject_old
implements ObserverObject,
ObservableObject,
ConfiguredObject {
    final String DEFAULT_RACK_NAMES_FILENAME = "rack_names.conf";
    public final long DEFAULT_TIMEOUT = 15000L;
    public final short NETWORK_STRUCTURE_TABLE_SIZE = (short)16;
    public short RACK_STRUCTURE_TABLE_SIZE = 0;
    int rackType = 0;
    MainDialog dialog;
    Socket_UDP socket;
    TrapSocket trap_socket;
    String rack_name = "";
    ArrayList<CoreSetting> settings = new ArrayList();
    public ArrayList<Gui> observers_guis_list = new ArrayList();
    public ArrayList<ProflexCard> cards_list = new ArrayList();
    short[] ipAddress_short = new short[4];
    IpAddress ipAddress = new IpAddress();
    String ipAddress_str;
    boolean is_alive;
    boolean is_running;
    boolean show_network_structure_messages = true;
    boolean show_rack_structure_messages = true;
    boolean show_block_structure_messages = true;
    boolean show_block_state_messages = true;
    boolean show_block_state_request_messages = true;
    boolean show_send_gui_block_state_messages = true;
    short[] rackStructureTable;
    short[] networkStructureTable = new short[this.NETWORK_STRUCTURE_TABLE_SIZE];
    ProflexRackManager rackManager;

    public ProflexRack() {
    }

    @Override
    public void GetObjectConfig() {
        try {
            for (CoreSetting s : this.settings) {
                s.GetSetting();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.GetObjectConfig(): " + e);
            this.dialog.AddLogRecord("ProflexRack.GetObjectConfig(): " + e);
        }
    }

    public short[] getIP() {
        return this.ipAddress_short;
    }

    public IpAddress getIP_IpAddress() {
        byte[] message_ip = new byte[]{(byte)this.ipAddress_short[0], (byte)this.ipAddress_short[1], (byte)this.ipAddress_short[2], (byte)this.ipAddress_short[3]};
        IpAddress addr = new IpAddress(message_ip);
        return addr;
    }

    public ProflexRack(Socket_UDP socket, TrapSocket trap_socket, MainDialog dialog, ProflexRackManager manager, short ip_1, short ip_2, short ip_3, short ip_4, int port) {
        this.socket = socket;
        this.trap_socket = trap_socket;
        this.dialog = dialog;
        this.rackManager = manager;
        this.cards_list.clear();
        this.ipAddress_short[0] = ip_1;
        this.ipAddress_short[1] = ip_2;
        this.ipAddress_short[2] = ip_3;
        this.ipAddress_short[3] = ip_4;
        byte[] val = new byte[]{(byte)ip_1, (byte)ip_2, (byte)ip_3, (byte)ip_4};
        this.ipAddress.setValue(val);
        this.ipAddress_str = this.ipAddress.toString();
        this.is_alive = false;
        this.is_running = true;
        int i = 0;
        for (i = 0; i < this.NETWORK_STRUCTURE_TABLE_SIZE; ++i) {
            this.networkStructureTable[i] = 0;
        }
        String rack_info = "Rack added ( IP = " + this.ipAddress.toString() + " )";
        this.timestamp = System.currentTimeMillis();
        this.settings.add(new CoreSetting("rack_show_network_structure_messages"));
        this.settings.add(new CoreSetting("rack_show_rack_structure_messages"));
        this.settings.add(new CoreSetting("rack_show_block_structure_messages"));
        this.settings.add(new CoreSetting("rack_show_block_state_messages"));
        this.settings.add(new CoreSetting("rack_show_block_state_request_messages"));
        this.settings.add(new CoreSetting("rack_show_send_gui_block_state_messages"));
        this.GetObjectConfig();
        this.show_network_structure_messages = this.settings.get(0).getValue_bool();
        this.show_rack_structure_messages = this.settings.get(1).getValue_bool();
        this.show_block_structure_messages = this.settings.get(2).getValue_bool();
        this.show_block_state_messages = this.settings.get(3).getValue_bool();
        this.show_block_state_request_messages = this.settings.get(4).getValue_bool();
        this.show_send_gui_block_state_messages = this.settings.get(5).getValue_bool();
        this.LoadRackName();
        this.setDaemon(true);
        this.setPriority(3);
        this.start();
    }

    public void LoadRackName() {
        try {
            ArrayList<String> fileStrings = new ArrayList<String>();
            String file_ip = "";
            String file_rack_name = "";
            int k = 0;
            boolean j = false;
            FileReader fileReader = new FileReader(this.DEFAULT_RACK_NAMES_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String s;
                while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                    fileStrings.add(s);
                }
                fileReader.close();
            }
            catch (Exception e) {
                System.out.println("RACK.LoadRackName() -> file read: " + e);
                this.dialog.AddLogRecord("RACK.LoadRackName() -> file read : " + e);
            }
            for (String s1 : fileStrings) {
                for (k = 0; k < s1.length(); ++k) {
                    if (s1.charAt(k) != '=') continue;
                    file_ip = s1.substring(0, k - 1);
                    file_rack_name = s1.substring(k + 1, s1.length());
                    break;
                }
                if (!file_ip.equals(this.ipAddress_str)) continue;
                this.rack_name = file_rack_name;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("GUI.ProcessNewRackName() -> file read: " + e);
            this.dialog.AddLogRecord("GUI.ProcessNewRackName() -> file read : " + e);
        }
    }

    public void AskRack() {
        this.GetRackStructureTable();
    }

    @Override
    public void run() {
        while (this.is_running) {
            String str_full;
            try {
                ProflexRack.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long current_timestamp = System.currentTimeMillis();
            if (current_timestamp - this.timestamp > this.DEFAULT_TIMEOUT) {
                if (!this.is_alive) continue;
                this.is_alive = false;
                str_full = "RACK LOST (IP =  " + this.ipAddress.toString() + "); Timeout = " + String.valueOf(current_timestamp - this.timestamp);
                System.out.println(str_full);
                this.dialog.AddLogRecord(str_full);
                this.AddRackJournalRecord(3);
                Message message = new Message();
                message.ZeroMessage();
                message.getClass();
                message.SetToHeader(2, this.ipAddress_short[0]);
                message.getClass();
                message.SetToHeader(3, this.ipAddress_short[1]);
                message.SetToHeader(message.POS_MESSAGE_IP3, this.ipAddress_short[2]);
                message.SetToHeader(message.POS_MESSAGE_IP4, this.ipAddress_short[3]);
                message.SetToHeader(message.POS_SIZE_OF_DATA, (short)5);
                message.SetToBody(0, (short)1);
                message.SetToBody(1, (short)0);
                message.SetToBody(2, (short)16);
                message.SetToBody(3, (short)9);
                message.SetToBody(4, (short)0);
                this.NotifyObservers(message);
                this.rackManager.RemoveRack(this.getIP());
                continue;
            }
            if (this.is_alive) continue;
            this.is_alive = true;
            str_full = "RACK FOUND (IP =  " + this.ipAddress.toString() + "); RACK_NAME = " + this.rack_name + "; Timeout = " + String.valueOf(current_timestamp - this.timestamp);
            System.out.println(str_full);
            this.dialog.AddLogRecord(str_full);
            this.AddRackJournalRecord(4);
            this.AskRack();
        }
    }

    public void AddRackJournalRecord(int alarm_type) {
        try {
            String full_str = " = ";
            switch (alarm_type) {
                case 3: {
                    full_str = full_str + "RACK_LOST; ";
                    break;
                }
                case 4: {
                    full_str = full_str + "RACK_FOUND; ";
                    break;
                }
                case 5: {
                    full_str = full_str + "CARD_LOST; ";
                    break;
                }
                case 6: {
                    full_str = full_str + "CARD_FOUND; ";
                    break;
                }
                default: {
                    System.out.println("ProflexRack.AddJournalRecord(): INVALID ALARM TYPE");
                    this.dialog.AddLogRecord("ProflexRack.AddJournalRecord(): INVALID ALARM TYPE");
                }
            }
            full_str = full_str + "NONE; ";
            full_str = full_str + "NONE; ";
            full_str = full_str + this.ipAddress_str + "; ";
            full_str = full_str + this.rack_name + "; ";
            full_str = full_str + String.valueOf(0) + "; ";
            full_str = full_str + String.valueOf(0) + "; ";
            full_str = full_str + "NONE;";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            Date date = new Date(System.currentTimeMillis());
            String date_str = sdf.format(date);
            full_str = date_str + full_str;
            this.dialog.AddNetworkRecord(full_str);
            this.SendGuiObservers_NewJournalRecord(full_str);
        }
        catch (Exception e) {
            System.out.println("ProflexRack.AddJournalRecord(): " + e);
            this.dialog.AddLogRecord("ProflexRack.AddJournalRecord(): " + e);
        }
    }

    public void AddCardJournalRecord(int alarm_type, int card_code, String card_name, int card_slot) {
        try {
            String full_str = " = ";
            switch (alarm_type) {
                case 5: {
                    full_str = full_str + "CARD_LOST; ";
                    break;
                }
                case 6: {
                    full_str = full_str + "CARD_FOUND; ";
                    break;
                }
                default: {
                    System.out.println("ProflexRack.AddCardJournalRecord(): INVALID ALARM TYPE");
                    this.dialog.AddLogRecord("ProflexRack.AddCardJournalRecord(): INVALID ALARM TYPE");
                }
            }
            full_str = full_str + "NONE; ";
            full_str = full_str + "NONE; ";
            full_str = full_str + this.ipAddress_str + "; ";
            full_str = full_str + this.rack_name + "; ";
            full_str = full_str + String.valueOf(card_slot) + "; ";
            full_str = full_str + String.valueOf(card_code) + "; ";
            full_str = full_str + card_name + ";";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            Date date = new Date();
            String date_str = sdf.format(date);
            full_str = date_str + full_str;
            this.dialog.AddNetworkRecord(full_str);
            this.SendGuiObservers_NewJournalRecord(full_str);
        }
        catch (Exception e) {
            System.out.println("ProflexRack.AddCardJournalRecord(): " + e);
            this.dialog.AddLogRecord("ProflexRack.AddCardJournalRecord(): " + e);
        }
    }

    public void ProcessMessage(Message message) {
        this.timestamp = System.currentTimeMillis();
        short message_type = message.GetFromBody(3);
        int i = 0;
        String str_buffer = "Message: ";
        short[] message_ip = message.getIP();
        String rack_ip = " (" + String.valueOf(message_ip[0]) + "." + String.valueOf(message_ip[1]) + "." + String.valueOf(message_ip[2]) + "." + String.valueOf(message_ip[3]) + ") ";
        switch (message_type) {
            case 8: {
                try {
                    this.timestamp = System.currentTimeMillis();
                    String str_mess = "RACK" + rack_ip + ": new [network structure] received";
                    short[] networkStructureTable_new = new short[this.NETWORK_STRUCTURE_TABLE_SIZE];
                    boolean b_have_changes = false;
                    for (i = 0; i < message.GetFromBody(4); ++i) {
                        networkStructureTable_new[i] = message.GetFromBody(5 + i);
                        if (networkStructureTable_new[i] != this.networkStructureTable[i]) {
                            b_have_changes = true;
                            this.networkStructureTable[i] = networkStructureTable_new[i];
                        }
                        str_buffer = str_buffer + this.networkStructureTable[i];
                        str_buffer = str_buffer + "  ";
                    }
                    if (!b_have_changes || !this.show_network_structure_messages) break;
                    this.dialog.AddLogRecord(str_mess);
                    this.dialog.AddLogRecord(str_buffer);
                    System.out.println(str_mess);
                    System.out.println(str_buffer);
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessMessage()->[network structure] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessMessage()->[network structure] : " + e);
                }
                break;
            }
            case 9: {
                try {
                    String str_mess = "RACK" + rack_ip + ": new [rack structure] received";
                    this.timestamp = System.currentTimeMillis();
                    if (this.RACK_STRUCTURE_TABLE_SIZE == 0) {
                        this.RACK_STRUCTURE_TABLE_SIZE = message.GetFromBody(4);
                        this.rackStructureTable = new short[this.RACK_STRUCTURE_TABLE_SIZE];
                        for (i = 0; i < this.RACK_STRUCTURE_TABLE_SIZE; ++i) {
                            this.rackStructureTable[i] = 0;
                        }
                    }
                    short[] rackStructureTable_new = new short[this.RACK_STRUCTURE_TABLE_SIZE];
                    int[] rackStructureTable_for_lazy_send = new int[this.RACK_STRUCTURE_TABLE_SIZE];
                    boolean b_have_changes = false;
                    int k = 0;
                    boolean b_card_changes = false;
                    boolean b_card_get_table_from_block = false;
                    for (i = 0; i < message.GetFromBody(4); i += 4) {
                        b_card_changes = false;
                        b_card_get_table_from_block = false;
                        for (k = 0; k < 4; ++k) {
                            short table_byte = message.GetFromBody(5 + i + k);
                            if (k == 0) {
                                if (table_byte != 0) {
                                    table_byte = 0;
                                    b_card_get_table_from_block = true;
                                } else {
                                    b_card_get_table_from_block = false;
                                }
                            }
                            rackStructureTable_new[i + k] = table_byte;
                            if (rackStructureTable_new[i + k] != this.rackStructureTable[i + k]) {
                                b_card_changes = true;
                                b_have_changes = true;
                                this.rackStructureTable[i + k] = rackStructureTable_new[i + k];
                            }
                            str_buffer = str_buffer + this.rackStructureTable[i + k];
                            str_buffer = str_buffer + "  ";
                        }
                        if (!b_card_changes) continue;
                        int card_code = 0;
                        int[] card_code_bytes = new int[4];
                        for (k = 0; k < 4; ++k) {
                            card_code_bytes[k] = (byte)this.rackStructureTable[i + k];
                        }
                        card_code |= (card_code_bytes[0] & 0xFF) << 24;
                        card_code |= (card_code_bytes[1] & 0xFF) << 16;
                        card_code |= (card_code_bytes[2] & 0xFF) << 8;
                        this.ModifyCard(card_code |= card_code_bytes[3] & 0xFF, b_card_get_table_from_block, (short)(i / 4));
                        if (card_code == 0) continue;
                        rackStructureTable_for_lazy_send[i / 4] = card_code;
                    }
                    if (!b_have_changes) break;
                    if (this.show_rack_structure_messages) {
                        this.dialog.AddLogRecord(str_mess);
                        this.dialog.AddLogRecord(str_buffer);
                        System.out.println(str_mess);
                        System.out.println(str_buffer);
                    }
                    this.NotifyObservers(message);
                    for (i = 0; i < this.RACK_STRUCTURE_TABLE_SIZE; ++i) {
                        if (rackStructureTable_for_lazy_send[i] == 0) continue;
                        this.SendGui_BlockStructure((short)i);
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessRackSocketMessage()->[rack structure] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessRackSocketMessage()->[rack structure] : " + e);
                    break;
                }
            }
            case 3: {
                try {
                    this.timestamp = System.currentTimeMillis();
                    short slot = message.GetFromBody(1);
                    String str_mess = "RACK" + rack_ip + ": slot = " + slot + ": new [block structure] received";
                    String mess = message.toString();
                    for (ProflexCard card : this.cards_list) {
                        if (card.slot != slot) continue;
                        int message_index = 0;
                        int string_length = message.GetFromBody(4);
                        char[] c = new char[string_length];
                        String controls_string = "";
                        for (message_index = 0; message_index < string_length; ++message_index) {
                            c[message_index] = (char)message.GetFromBody(message_index + 5);
                        }
                        controls_string = String.valueOf(c);
                        card.ProcessControlsTable(controls_string);
                        break;
                    }
                    if (this.show_block_structure_messages) {
                        str_mess = str_mess + " = " + mess;
                        this.dialog.AddLogRecord(str_mess);
                        System.out.println(str_mess);
                    }
                    if (this.observers_guis_list.size() <= 0) break;
                    this.SendGui_BlockStructure(slot);
                    this.GetCardStateTable(slot);
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessRackSocketMessage()->[block structure] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessRackSocketMessage()->[block structure] : " + e);
                }
                break;
            }
            case 6: {
                try {
                    this.timestamp = System.currentTimeMillis();
                    short slot = message.GetFromBody(1);
                    int table_length = message.GetFromBody(4) - 4;
                    boolean b_have_changes = false;
                    String str_mess = "RACK" + rack_ip + ": slot = " + slot + ": new [block state] received";
                    String mess = message.toString();
                    for (ProflexCard card : this.cards_list) {
                        if (card.slot != slot) continue;
                        card.state_table_length = (short)table_length;
                        for (i = 0; i < table_length; ++i) {
                            if (card.state_table[i] == message.GetFromBody(9 + i)) continue;
                            b_have_changes = true;
                            card.state_table[i] = message.GetFromBody(9 + i);
                        }
                        if (!b_have_changes) break;
                        card.SetStateTable(card.state_table, card.state_table_length);
                        card.CheckMonitoringParams();
                        break;
                    }
                    if (this.show_block_state_messages) {
                        this.dialog.AddLogRecord(str_mess);
                        System.out.println(str_mess);
                    }
                    if (this.observers_guis_list.size() <= 0) break;
                    this.SendGui_BlockState(slot);
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessRackSocketMessage()->[block state] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessRackSocketMessage()->[block state] : " + e);
                }
                break;
            }
            case 112: {
                try {
                    this.timestamp = System.currentTimeMillis();
                    short slot = message.GetFromBody(1);
                    int table_length = message.GetFromBody(4) - 4;
                    boolean b_have_changes = false;
                    String str_mess = "RACK" + rack_ip + ": slot = " + slot + ": [setting processed] received";
                    if (this.show_block_state_messages) {
                        this.dialog.AddLogRecord(str_mess);
                        System.out.println(str_mess);
                    }
                    this.GetCardStateTable(slot);
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessRackSocketMessage()->[setting processed] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessRackSocketMessage()->[setting processed] : " + e);
                }
                break;
            }
            case 255: {
                try {
                    this.timestamp = System.currentTimeMillis();
                    short slot = message.GetFromBody(1);
                    int table_length = message.GetFromBody(4) - 4;
                    boolean b_have_changes = false;
                    String str_mess = "RACK" + rack_ip + ": slot = " + slot + ": [CHECKSUM ERROR] received";
                    if (!this.show_block_state_messages) break;
                    this.dialog.AddLogRecord(str_mess);
                    System.out.println(str_mess);
                }
                catch (Exception e) {
                    System.out.println("RACK" + rack_ip + ": ProcessRackSocketMessage()->[CHECKSUM ERROR] : " + e);
                    this.dialog.AddLogRecord("RACK" + rack_ip + ": ProcessRackSocketMessage()->[CHECKSUM ERROR] : " + e);
                }
                break;
            }
            default: {
                this.timestamp = System.currentTimeMillis();
                String str_mess = "RACK" + rack_ip + ": received message. Type is [unknown]" + message_type;
                System.out.println(str_mess);
                this.dialog.AddLogRecord(str_mess);
                this.timestamp = System.currentTimeMillis();
                break;
            }
        }
    }

    private void SendGui_BlockStructure(short slot) {
        try {
            if (this.show_block_structure_messages) {
                System.out.println("ProflexRack.SendGui_BlockStructure(): cards_num = " + this.cards_list.size());
                this.dialog.AddLogRecord("ProflexRack.SendGui_BlockStructure(): cards_num = " + this.cards_list.size());
                System.out.println("ProflexRack.SendGui_BlockStructure(): want_send_slot = " + slot);
                this.dialog.AddLogRecord("ProflexRack.SendGui_BlockStructure(): want_send_slot = " + slot);
            }
            for (ProflexCard card : this.cards_list) {
                if (card.slot != slot) continue;
                Message message = new Message();
                message.getClass();
                message.SetToHeader(2, this.ipAddress_short[0]);
                message.getClass();
                message.SetToHeader(3, this.ipAddress_short[1]);
                message.SetToHeader(message.POS_MESSAGE_IP3, this.ipAddress_short[2]);
                message.SetToHeader(message.POS_MESSAGE_IP4, this.ipAddress_short[3]);
                String str = "";
                for (String card_setting_string : card.control_table_list) {
                    str = str + card_setting_string;
                    str = str + ";";
                }
                int string_size = str.length();
                message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(string_size + 5));
                message.SetToBody(0, (short)1);
                message.SetToBody(1, slot);
                message.SetToBody(2, (short)16);
                message.SetToBody(3, (short)3);
                message.SetToBody(4, (short)string_size);
                int i = 0;
                for (i = 0; i < string_size; ++i) {
                    message.SetToBody(5 + i, (short)str.charAt(i));
                }
                if (this.show_block_structure_messages) {
                    System.out.println("ProflexRack.SendGui_BlockStructure(): send slot = " + slot);
                    this.dialog.AddLogRecord("ProflexRack.SendGui_BlockStructure(): send slot = " + slot);
                }
                this.NotifyObservers(message);
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.SendGui_BlockStructure() : " + e);
            this.dialog.AddLogRecord("ProflexRack.SendGui_BlockStructure() : " + e);
        }
    }

    private void SendGui_BlockState(short slot) {
        try {
            for (ProflexCard card : this.cards_list) {
                if (card.slot != slot) continue;
                if (card.state_table_length == 0) {
                    this.GetCardStateTable(slot);
                    continue;
                }
                Message message = new Message();
                message.getClass();
                message.SetToHeader(2, this.ipAddress_short[0]);
                message.getClass();
                message.SetToHeader(3, this.ipAddress_short[1]);
                message.SetToHeader(message.POS_MESSAGE_IP3, this.ipAddress_short[2]);
                message.SetToHeader(message.POS_MESSAGE_IP4, this.ipAddress_short[3]);
                int table_length = card.state_table_length;
                message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(table_length + 9));
                message.SetToBody(0, (short)1);
                message.SetToBody(1, slot);
                message.SetToBody(2, (short)16);
                message.SetToBody(3, (short)6);
                message.SetToBody(4, (short)table_length);
                message.SetToBody(5, (short)0);
                message.SetToBody(6, (short)0);
                message.SetToBody(7, (short)0);
                message.SetToBody(8, (short)0);
                int i = 0;
                for (i = 0; i < table_length; ++i) {
                    message.SetToBody(9 + i, card.state_table[i]);
                }
                if (this.show_send_gui_block_state_messages) {
                    System.out.println("ProflexRack.SendGui_BlockState(): send gui block state, slot = " + slot);
                    this.dialog.AddLogRecord("ProflexRack.SendGui_BlockState(): send gui block state, slot = " + slot);
                }
                this.NotifyObservers(message);
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.SendGui_BlockState() : " + e);
            this.dialog.AddLogRecord("ProflexRack.SendGui_BlockState() : " + e);
        }
    }

    public void SendGui_AllRack(ObserverObject gui) {
        try {
            Message message = new Message();
            message.getClass();
            message.SetToHeader(2, this.ipAddress_short[0]);
            message.getClass();
            message.SetToHeader(3, this.ipAddress_short[1]);
            message.SetToHeader(message.POS_MESSAGE_IP3, this.ipAddress_short[2]);
            message.SetToHeader(message.POS_MESSAGE_IP4, this.ipAddress_short[3]);
            message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(this.RACK_STRUCTURE_TABLE_SIZE + 5));
            message.SetToBody(0, (short)1);
            message.SetToBody(1, (short)0);
            message.SetToBody(2, (short)16);
            message.SetToBody(3, (short)9);
            message.SetToBody(4, this.RACK_STRUCTURE_TABLE_SIZE);
            int i = 0;
            for (i = 0; i < this.RACK_STRUCTURE_TABLE_SIZE; ++i) {
                message.SetToBody(5 + i, this.rackStructureTable[i]);
            }
            for (ObserverObject observerObject : this.observers_guis_list) {
                if (observerObject != gui) continue;
                observerObject.ProcessEvent(message);
            }
            if (this.show_block_structure_messages) {
                System.out.println("ProflexRack.SendGui_AllRack(): cards_num = " + this.cards_list.size());
                this.dialog.AddLogRecord("ProflexRack.SendGui_AllRack(): cards_num = " + this.cards_list.size());
            }
            block4: for (ProflexCard proflexCard : this.cards_list) {
                message.ZeroMessage();
                message.getClass();
                message.SetToHeader(2, this.ipAddress_short[0]);
                message.getClass();
                message.SetToHeader(3, this.ipAddress_short[1]);
                message.SetToHeader(message.POS_MESSAGE_IP3, this.ipAddress_short[2]);
                message.SetToHeader(message.POS_MESSAGE_IP4, this.ipAddress_short[3]);
                String str = "";
                for (String card_setting_string : proflexCard.control_table_list) {
                    str = str + card_setting_string;
                    str = str + ";";
                }
                int string_size = str.length();
                message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(string_size + 5));
                message.SetToBody(0, (short)1);
                message.SetToBody(1, proflexCard.slot);
                message.SetToBody(2, (short)16);
                message.SetToBody(3, (short)3);
                message.SetToBody(4, (short)string_size);
                for (i = 0; i < string_size; ++i) {
                    message.SetToBody(5 + i, (short)str.charAt(i));
                }
                for (ObserverObject observerObject : this.observers_guis_list) {
                    if (observerObject != gui) continue;
                    observerObject.ProcessEvent(message);
                    continue block4;
                }
            }
            for (ObserverObject observerObject : this.observers_guis_list) {
                if (observerObject != gui) continue;
                for (ProflexCard card_st : this.cards_list) {
                    this.SendGui_BlockState(card_st.slot);
                }
            }
            for (ObserverObject observerObject : this.observers_guis_list) {
                if (observerObject != gui) continue;
                for (ProflexCard card_st : this.cards_list) {
                    card_st.SendGUI_AllCurrentAlarms();
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.SendGui_AllRack() : " + e);
            this.dialog.AddLogRecord("ProflexRack.SendGui_AllRack() : " + e);
        }
    }

    public void SendGuiObservers_Alarm(Message message) {
        for (Gui gui_observer : this.observers_guis_list) {
            gui_observer.SendGUI_Alarm(message);
        }
    }

    public void Send_Trap(Message message) {
        int[] data = new int[10];
        data[0] = message.GetFromBody(2);
        data[1] = message.GetFromBody(3);
        data[2] = message.GetFromBody(4);
        data[3] = message.GetFromBody(5);
        short slot = message.GetFromBody(6);
        for (ProflexCard card : this.cards_list) {
            if (card.slot != slot) continue;
            data[4] = card.code;
        }
        data[5] = 1;
        data[6] = 1;
        data[7] = message.GetFromBody(7);
        data[8] = message.GetFromBody(6);
        data[9] = message.GetFromBody(11);
        this.trap_socket.SendTrap(data);
    }

    public void SendGuiObservers_UserBLockAlarmsFile() {
        if (this.observers_guis_list.size() > 0) {
            for (Gui gui_observer : this.observers_guis_list) {
                gui_observer.SendGUI_UserBlocksAlarmsFiles();
            }
        }
    }

    public void SendGuiObservers_NewJournalRecord(String record) {
        if (this.observers_guis_list.size() > 0) {
            for (Gui gui_observer : this.observers_guis_list) {
                gui_observer.SendGUI_JournalRecord(record);
            }
        }
    }

    private void RemoveCard(short slot) {
        try {
            for (ProflexCard card : this.cards_list) {
                if (card.slot != slot) continue;
                this.cards_list.remove(card);
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.RemoveCard() : " + e);
            this.dialog.AddLogRecord("ProflexRack.RemoveCard() : " + e);
        }
    }

    private void ModifyCard(int code, boolean b_get_table_from_card, short slot) {
        try {
            boolean b_found = false;
            int old_card_code = 0;
            String old_card_name = "NONE";
            for (ProflexCard card : this.cards_list) {
                if (card.slot != slot) continue;
                b_found = true;
                old_card_code = card.code;
                old_card_name = card.name;
                if (old_card_code == 0 || code != 0) break;
                this.AddCardJournalRecord(5, old_card_code, old_card_name, slot);
                break;
            }
            if (b_found) {
                this.RemoveCard(slot);
            }
            if (code != 0) {
                ProflexCard new_card = new ProflexCard(this.dialog, this, this.getIP_IpAddress(), code, b_get_table_from_card, slot);
                this.cards_list.add(new_card);
                if (old_card_code == 0 && code != 0) {
                    this.AddCardJournalRecord(6, new_card.code, new_card.name, slot);
                }
                if (new_card.bCardLoadControlsTable) {
                    this.GetCardControlsTable(slot);
                }
                this.GetCardStateTable(slot);
            }
            if (this.show_block_structure_messages) {
                System.out.println("RACK (" + this.ipAddress.toString() + "): ProflexRack.ModifyCard(): card modified: slot = " + slot + ", code = " + code);
                this.dialog.AddLogRecord("RACK (" + this.ipAddress.toString() + "): ProflexRack.ModifyCard(): card modified: slot = " + slot + ", code = " + code);
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.ModifyCard() : " + e);
            this.dialog.AddLogRecord("ProflexRack.ModifyCard() : " + e);
        }
    }

    @Override
    public void AddObserver(ObserverObject observer) {
        this.observers_guis_list.add((Gui)observer);
    }

    @Override
    public void RemoveObserver(ObserverObject observer) {
        try {
            this.observers_guis_list.remove(observer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void NotifyObservers() {
    }

    @Override
    public void NotifyObservers(String str) {
        try {
            for (ObserverObject observerObject : this.observers_guis_list) {
                if (observerObject == null) continue;
                observerObject.ProcessEvent(str);
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.NotifyObservers() : " + e);
            this.dialog.AddLogRecord("ProflexRack.NotifyObservers() : " + e);
        }
    }

    @Override
    public void NotifyObservers(Message message) {
        try {
            for (ObserverObject observerObject : this.observers_guis_list) {
                if (observerObject == null) continue;
                observerObject.ProcessEvent(message);
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRack.NotifyObservers() : " + e);
            this.dialog.AddLogRecord("ProflexRack.NotifyObservers() : " + e);
        }
    }

    @Override
    public void ProcessEvent() {
    }

    @Override
    public void ProcessEvent(String str) {
    }

    @Override
    public void ProcessEvent(Message message) {
        System.out.println("ProflexRack message received: = " + message.toString());
    }

    public void GetRackStructureTable() {
        Message m = new Message();
        m.ZeroMessage();
        m.getClass();
        m.SetToHeader(2, this.ipAddress_short[0]);
        m.getClass();
        m.SetToHeader(3, this.ipAddress_short[1]);
        m.SetToHeader(m.POS_MESSAGE_IP3, this.ipAddress_short[2]);
        m.SetToHeader(m.POS_MESSAGE_IP4, this.ipAddress_short[3]);
        m.SetToHeader(m.POS_SIZE_OF_DATA, (short)5);
        m.SetToBody(0, (short)1);
        m.SetToBody(1, (short)0);
        m.SetToBody(2, (short)128);
        m.SetToBody(3, (short)9);
        m.SetToBody(4, (short)0);
        this.socket.Write(m);
    }

    public void GetCardStateTable(short slot) {
        Message m = new Message();
        m.ZeroMessage();
        m.getClass();
        m.SetToHeader(2, this.ipAddress_short[0]);
        m.getClass();
        m.SetToHeader(3, this.ipAddress_short[1]);
        m.SetToHeader(m.POS_MESSAGE_IP3, this.ipAddress_short[2]);
        m.SetToHeader(m.POS_MESSAGE_IP4, this.ipAddress_short[3]);
        m.SetToHeader(m.POS_SIZE_OF_DATA, (short)5);
        m.SetToBody(0, (short)1);
        m.SetToBody(1, slot);
        m.SetToBody(2, (short)128);
        m.SetToBody(3, (short)6);
        m.SetToBody(4, (short)0);
        if (this.show_block_state_request_messages) {
            System.out.println("RACK (" + this.ipAddress.toString() + "): ProflexRack.GetCardStateTable(): card state ask slot = " + slot);
            this.dialog.AddLogRecord("RACK (" + this.ipAddress.toString() + "): ProflexRack.GetCardStateTable(): card state ask slot = " + slot);
        }
        this.socket.Write(m);
    }

    public void GetCardControlsTable(short slot) {
        Message m = new Message();
        m.ZeroMessage();
        m.getClass();
        m.SetToHeader(2, this.ipAddress_short[0]);
        m.getClass();
        m.SetToHeader(3, this.ipAddress_short[1]);
        m.SetToHeader(m.POS_MESSAGE_IP3, this.ipAddress_short[2]);
        m.SetToHeader(m.POS_MESSAGE_IP4, this.ipAddress_short[3]);
        m.SetToHeader(m.POS_SIZE_OF_DATA, (short)5);
        m.SetToBody(0, (short)1);
        this.dialog.AddLogRecord("!!!!!!!!!!!!!!!!!!!!!!! GetCardControlsTable: slot = " + slot);
        m.SetToBody(1, slot);
        m.SetToBody(2, (short)128);
        m.SetToBody(3, (short)3);
        m.SetToBody(4, (short)0);
        if (this.show_block_state_request_messages) {
            System.out.println("RACK (" + this.ipAddress.toString() + "): ProflexRack.GetCardControlsTable(): card table ask slot = " + slot);
            this.dialog.AddLogRecord("RACK (" + this.ipAddress.toString() + "): ProflexRack.GetCardControlsTable(): card table ask slot = " + slot);
        }
        this.socket.Write(m);
    }

    public void SetBlockSetting(short slot, short setting_num, short value) {
        short val_hi = 0;
        short val_lo = 0;
        val_hi = (short)((value & 0xFF00) >> 8);
        val_lo = (short)(value & 0xFF);
        Message m = new Message();
        m.ZeroMessage();
        m.getClass();
        m.SetToHeader(2, this.ipAddress_short[0]);
        m.getClass();
        m.SetToHeader(3, this.ipAddress_short[1]);
        m.SetToHeader(m.POS_MESSAGE_IP3, this.ipAddress_short[2]);
        m.SetToHeader(m.POS_MESSAGE_IP4, this.ipAddress_short[3]);
        m.SetToHeader(m.POS_SIZE_OF_DATA, (short)8);
        m.SetToBody(0, (short)1);
        m.SetToBody(1, slot);
        m.SetToBody(2, (short)128);
        m.SetToBody(3, (short)5);
        m.SetToBody(4, (short)3);
        m.SetToBody(5, setting_num);
        m.SetToBody(6, val_lo);
        m.SetToBody(7, val_hi);
        this.socket.Write(m);
    }
}

