/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import org.snmp4j.smi.IpAddress;

public class ProflexRackManager
implements ObserverObject,
ConfiguredObject {
    MainDialog dialog;
    MainClass mainClass;
    Socket_UDP socket;
    TrapSocket trap_socket;
    ArrayList<ProflexRack> rack_list = new ArrayList();
    boolean show_add_delete_rack_messages = false;

    public ProflexRackManager(Socket_UDP socket, TrapSocket trap_socket, MainDialog dialog, MainClass mc) {
        this.dialog = dialog;
        this.mainClass = mc;
        this.socket = socket;
        this.trap_socket = trap_socket;
        this.rack_list.clear();
    }

    public ProflexRack getRack(short[] ip) {
        try {
            for (ProflexRack rack : this.rack_list) {
                short[] rack_ip = rack.getIP();
                if (!Arrays.equals(rack_ip, ip)) continue;
                return rack;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRackManager.getRack(): " + e);
            this.dialog.AddLogRecord("ProflexRackManager.getRack(): " + e);
        }
        return null;
    }

    public void ProcessRackMessage(Message message) {
        try {
            boolean b_found = false;
            short[] message_ip = message.getIP();
            for (ProflexRack rack : this.rack_list) {
                short[] rack_ip = rack.getIP();
                if (!Arrays.equals(message_ip, rack_ip)) continue;
                rack.ProcessMessage(message);
                b_found = true;
                break;
            }
            if (!b_found) {
                message.getClass();
                short s = message.GetFromHeader(2);
                message.getClass();
                ProflexRack rack = new ProflexRack(this.socket, this.trap_socket, this.dialog, this, s, message.GetFromHeader(3), message.GetFromHeader(message.POS_MESSAGE_IP3), message.GetFromHeader(message.POS_MESSAGE_IP4), message.GetFromHeader(message.POS_MESSAGE_PORT));
                this.rack_list.add(rack);
                if (this.show_add_delete_rack_messages) {
                    String str_full = "";
                    String list_rack_ip = String.valueOf(message_ip[0]) + "." + String.valueOf(message_ip[1]) + "." + String.valueOf(message_ip[2]) + "." + String.valueOf(message_ip[3]);
                    str_full = "RackManager->ProcessRackMessage/AddNewRack(): (rack = " + list_rack_ip + ") rack_list =  ";
                    for (ProflexRack rack_list : this.rack_list) {
                        short[] list_rack_new_ip_short = rack_list.getIP();
                        list_rack_ip = String.valueOf(list_rack_new_ip_short[0]) + "." + String.valueOf(list_rack_new_ip_short[1]) + "." + String.valueOf(list_rack_new_ip_short[2]) + "." + String.valueOf(list_rack_new_ip_short[3]);
                        str_full = str_full + list_rack_ip + ", ";
                    }
                    System.out.println(str_full);
                    this.dialog.AddLogRecord(str_full);
                }
                rack.ProcessMessage(message);
                rack.AskRack();
            }
        }
        catch (Exception e) {
            System.out.println("ProflexRackManager.ProcessRackMessage(): " + e);
            this.dialog.AddLogRecord("ProflexRackManager.ProcessRackMessage(): " + e);
        }
    }

    @Override
    public void ProcessEvent() {
    }

    @Override
    public void ProcessEvent(String str) {
    }

    @Override
    public void ProcessEvent(Message message) {
    }

    public synchronized void RemoveGUI(Gui gui) {
        for (ProflexRack rack : this.rack_list) {
            rack.RemoveObserver(gui);
            String client_info = " (IP = " + String.valueOf(gui.ip[0]) + "." + String.valueOf(gui.ip[1]) + "." + String.valueOf(gui.ip[2]) + "." + String.valueOf(gui.ip[3]) + ") ";
            String rack_info = rack.ipAddress.toString();
            String str_mess = "RackManager.RemoveGUI(): " + client_info + " from rack (" + rack_info + ")";
            this.dialog.AddLogRecord(str_mess);
            System.out.println(str_mess);
        }
    }

    public void RemoveRack(short[] ip) {
        for (ProflexRack rack : this.rack_list) {
            if (!Arrays.equals(ip, rack.getIP())) continue;
            this.rack_list.remove(rack);
            break;
        }
        if (this.show_add_delete_rack_messages) {
            String str_full = "";
            String list_rack_ip = String.valueOf(ip[0]) + "." + String.valueOf(ip[1]) + "." + String.valueOf(ip[2]) + "." + String.valueOf(ip[3]);
            str_full = "RackManager->RemoveRack(): (rack = " + list_rack_ip + ") rack_list =  ";
            for (ProflexRack rack_list : this.rack_list) {
                short[] list_rack_new_ip_short = rack_list.getIP();
                list_rack_ip = String.valueOf(list_rack_new_ip_short[0]) + "." + String.valueOf(list_rack_new_ip_short[1]) + "." + String.valueOf(list_rack_new_ip_short[2]) + "." + String.valueOf(list_rack_new_ip_short[3]);
                str_full = str_full + list_rack_ip + ", ";
            }
            System.out.println(str_full);
            this.dialog.AddLogRecord(str_full);
        }
    }

    @Override
    public void GetObjectConfig() {
    }

    public void RegisterGuiInRacks(Gui gui) {
        boolean yy = false;
        block0: for (IpAddress ipAddress : gui.resolved_rack_list) {
            for (ProflexRack rack : this.rack_list) {
                if (!ipAddress.equals(rack.ipAddress)) continue;
                rack.AddObserver(gui);
                gui.AddObserver(rack);
                String client_info = " GUI (IP = " + String.valueOf(gui.ip[0]) + "." + String.valueOf(gui.ip[1]) + "." + String.valueOf(gui.ip[2]) + "." + String.valueOf(gui.ip[3]) + ") " + " registered in RACK (IP = " + String.valueOf(rack.ipAddress_short[0]) + "." + String.valueOf(rack.ipAddress_short[1]) + "." + String.valueOf(rack.ipAddress_short[2]) + "." + String.valueOf(rack.ipAddress_short[3]) + ") ";
                String str_mess = "PROFLEX_RACK_MANAGER: " + client_info;
                System.out.println(str_mess);
                this.dialog.AddLogRecord(str_mess);
                continue block0;
            }
        }
    }
}

