/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.snmp4j.smi.IpAddress;

public class ProflexSetting {
    private final String DEFAULT_MONITORING_SETTINGS_FILENAME = "core_monitoring_settings.conf";
    MainDialog dialog;
    ProflexRack rack;
    ProflexCard card;
    private String ip_string;
    IpAddress ipAddress;
    String setting_string;
    String name;
    short slot;
    long card_code;
    int setting_number;
    short value;
    float multiplier;
    float multiplied_value;
    boolean isLoaded;
    boolean is_first_time_checked;
    short checking_flag;
    short lowerLim;
    short upperLim;
    short invalidValue;
    short isActive;
    short isSendTrap;
    short gui_table_line_index;
    long file_block_code;
    boolean is_alarm_now;

    public ProflexSetting(MainDialog dialog, ProflexRack rack, ProflexCard card, IpAddress ip, short slot, int setting_num, String setting_str, long card_code) {
        block10: {
            int right_bracket_pos;
            int left_bracket_pos;
            int j;
            block9: {
                this.DEFAULT_MONITORING_SETTINGS_FILENAME = "core_monitoring_settings.conf";
                this.checking_flag = 0;
                this.lowerLim = 0;
                this.upperLim = 0;
                this.invalidValue = 0;
                this.isActive = 0;
                this.isSendTrap = 0;
                this.gui_table_line_index = 0;
                this.file_block_code = 0L;
                this.dialog = dialog;
                this.rack = rack;
                this.card = card;
                this.ipAddress = ip;
                this.ip_string = this.ipAddress.toString();
                this.slot = slot;
                this.card_code = card_code;
                this.isLoaded = false;
                this.setting_number = setting_num;
                this.setting_string = setting_str;
                this.value = 0;
                this.multiplier = 1.0f;
                this.multiplied_value = this.value;
                this.is_alarm_now = false;
                this.is_first_time_checked = false;
                try {
                    int i = 0;
                    j = 0;
                    left_bracket_pos = 0;
                    right_bracket_pos = 0;
                    for (i = 0; i < this.setting_string.length(); ++i) {
                        if (this.setting_string.charAt(i) != '[') continue;
                        for (j = i; j < this.setting_string.length(); ++j) {
                            if (this.setting_string.charAt(j) != ']') continue;
                            String multiplier_string = this.setting_string.substring(i + 1, j);
                            this.multiplier = Float.parseFloat(multiplier_string);
                            this.multiplied_value = (float)this.value * this.multiplier;
                            break block9;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("ProflexSetting.ProflexSetting(): " + e);
                    this.dialog.AddLogRecord("ProflexSetting.ProflexSetting(): " + e);
                }
            }
            try {
                if (this.setting_string.length() <= 2) break block10;
                int i = 0;
                j = 0;
                left_bracket_pos = 0;
                right_bracket_pos = 0;
                for (i = 0; i < 2; ++i) {
                    if (this.setting_string.charAt(i) == '#' || this.setting_string.charAt(i) == '$' || this.setting_string.charAt(i) == '~' || this.setting_string.charAt(i) == '|' || this.setting_string.charAt(i) == '%') {
                        ++left_bracket_pos;
                    }
                    if (this.setting_string.charAt(i) == ',' || this.setting_string.charAt(i) == ';') break;
                }
                for (i = 0; i < this.setting_string.length(); ++i) {
                    if (this.setting_string.charAt(i) != '[' && this.setting_string.charAt(i) != ',' && this.setting_string.charAt(i) != ';') continue;
                    right_bracket_pos = i;
                    this.name = left_bracket_pos < right_bracket_pos ? this.setting_string.substring(left_bracket_pos, right_bracket_pos) : "none";
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("ProflexSetting.ProflexSetting(): get setting name (" + this.setting_string + ")  " + e);
                this.dialog.AddLogRecord("ProflexSetting.ProflexSetting(): get setting name (" + this.setting_string + ")" + e);
            }
        }
    }

    public void LoadSettings() {
        try {
            FileReader fileReader = new FileReader(this.DEFAULT_MONITORING_SETTINGS_FILENAME);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String s = null;
            while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                String s_block;
                String file_ip;
                if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']' || !(file_ip = (s = s.replaceAll(" ", "")).substring(1, s.length() - 1)).equals(this.ip_string)) continue;
                while ((s_block = bufferedReader.readLine()) != null) {
                    if (s_block.charAt(0) == '[' && s_block.charAt(s_block.length() - 1) == ']') {
                        return;
                    }
                    s_block = s_block.replaceAll(" ", "");
                    String[] splitted = s_block.split(";");
                    int[] table = new int[10];
                    for (int i = 0; i < 10; ++i) {
                        table[i] = Integer.parseInt(splitted[i]);
                        if (splitted[i] != "0") continue;
                        table[i] = 0;
                    }
                    if (table[0] != this.slot || table[1] != this.setting_number) continue;
                    this.isLoaded = true;
                    this.checking_flag = (short)table[2];
                    this.lowerLim = (short)table[3];
                    this.upperLim = (short)table[4];
                    this.invalidValue = (short)table[5];
                    this.isActive = (short)table[6];
                    this.isSendTrap = (short)table[7];
                    this.gui_table_line_index = (short)table[8];
                    this.file_block_code = table[9];
                    if (this.file_block_code != this.card_code) {
                        this.isActive = 0;
                    }
                    fileReader.close();
                    return;
                }
            }
            fileReader.close();
            this.GetAlarmNameFromDefaultAlarmsFiles();
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.LoadSettings(): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetAlarmNameFromDefaultAlarmsFiles() {
        try {
            File folder = new File("DEFAULT_BLOCKS_ALARMS");
            File[] listOfFiles = folder.listFiles();
            int i = 0;
            for (i = 0; i < listOfFiles.length; ++i) {
                String file_name = listOfFiles[i].getName();
                long block_code = this.card.code;
                if (block_code == 0L) {
                    return;
                }
                int k = 0;
                String codestr = "F";
                String str_val_dec = Long.toHexString(block_code);
                if ((str_val_dec = str_val_dec.toUpperCase()).length() > 8) {
                    return;
                }
                if (str_val_dec.length() < 8) {
                    for (k = 0; k < 7 - str_val_dec.length(); ++k) {
                        codestr = codestr + "0";
                    }
                    codestr = codestr + str_val_dec + "_A.txt";
                }
                if (codestr.length() < 7) {
                    boolean ppp = false;
                }
                if (!file_name.equals(codestr)) continue;
                FileInputStream fis = new FileInputStream(listOfFiles[i].getPath());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fis, "Cp1251"));
                ArrayList<String> fileStrings = new ArrayList<String>();
                try {
                    String s;
                    while ((s = bufferedReader.readLine()) != null && s.length() > 0) {
                        fileStrings.add(s);
                    }
                    fis.close();
                }
                catch (IOException ex) {
                    System.out.println("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file read : " + ex);
                    this.dialog.AddLogRecord("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file read : " + ex);
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file close : " + ex);
                        this.dialog.AddLogRecord("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file close : " + ex);
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file close : " + ex);
                        this.dialog.AddLogRecord("Journal.GetAlarmNameFromDefaultAlarmsFiles() -> journal file close : " + ex);
                    }
                }
                block22: for (String fileLine : fileStrings) {
                    fileLine.replace(" ", "");
                    String[] splitted_array = fileLine.split(";");
                    k = 0;
                    int file_setting_number = Integer.parseInt(splitted_array[1]);
                    if (splitted_array[1] == "0") {
                        file_setting_number = 0;
                    }
                    for (k = 0; k < splitted_array.length; ++k) {
                        if (file_setting_number != this.setting_number) continue;
                        this.name = splitted_array[0];
                        continue block22;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.GetAlarmNameFromDefaultAlarmsFiles(): " + e);
            this.dialog.AddLogRecord("ProflexSetting.GetAlarmNameFromDefaultAlarmsFiles(): " + e);
        }
    }

    public void SetMonitoringParams(short checking_flag, short lower_lim, short upper_lim, short invalid_value, short is_active, short is_send_trap, short gui_table_line_index, long block_code) {
        try {
            this.checking_flag = checking_flag;
            this.lowerLim = lower_lim;
            this.upperLim = upper_lim;
            this.invalidValue = invalid_value;
            this.isActive = is_active;
            if (this.is_alarm_now && this.isActive == 0) {
                this.is_alarm_now = false;
            }
            if (this.isActive == 0) {
                this.is_first_time_checked = false;
            }
            this.isSendTrap = is_send_trap;
            this.gui_table_line_index = gui_table_line_index;
            this.SendGUI_CurrentAlarmState();
            this.CheckMonitoringParams();
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.SetMonitoringParams(): " + e);
            this.dialog.AddLogRecord("ProflexSetting.SetMonitoringParams(): " + e);
        }
    }

    public void AddJournalRecord(int alarm_type) {
        try {
            String full_str = " = ";
            switch (alarm_type) {
                case 1: {
                    full_str = full_str + "ALARM_ON; ";
                    break;
                }
                case 2: {
                    full_str = full_str + "ALARM_OFF; ";
                    break;
                }
                default: {
                    System.out.println("ProflexSetting.AddJournalRecord(): INVALID ALARM TYPE");
                    this.dialog.AddLogRecord("ProflexSetting.AddJournalRecord(): INVALID ALARM TYPE");
                }
            }
            if (this.setting_number < 1) {
                this.name = "INPUT";
            }
            full_str = full_str + this.name + "; ";
            full_str = full_str + this.gui_table_line_index + "; ";
            full_str = full_str + this.ip_string + "; ";
            full_str = full_str + this.rack.rack_name + "; ";
            full_str = full_str + String.valueOf(this.slot) + "; ";
            full_str = full_str + String.valueOf(this.card_code) + "; ";
            full_str = full_str + this.card.name + "; ";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            Date date = new Date();
            String date_str = sdf.format(date);
            full_str = date_str + full_str;
            this.dialog.AddNetworkRecord(full_str);
            this.rack.SendGuiObservers_NewJournalRecord(full_str);
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.AddJournalRecord(): " + e);
            this.dialog.AddLogRecord("ProflexSetting.AddJournalRecord(): " + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void CheckMonitoringParams() {
        try {
            if (this.card_code == 154L) {
                boolean kkk = false;
            }
            if (this.isActive != 0 && this.file_block_code == this.card_code) {
                short[] card_code_byte = new short[]{(short)(this.file_block_code >> 24), (short)(this.file_block_code >> 16 & 0xFFL), (short)(this.file_block_code >> 8 & 0xFFL), (short)(this.file_block_code & 0xFFL)};
                if (this.checking_flag == 1) {
                    short val = this.value;
                    val = (short)(val << 2);
                    if ((val = (short)(val >> 2)) >= this.lowerLim && val <= this.upperLim) {
                        if (this.is_alarm_now) {
                            this.is_alarm_now = false;
                            Message message = new Message();
                            message.SetToBody(0, (short)16);
                            message.SetToBody(1, (short)91);
                            message.SetToBody(2, this.rack.ipAddress_short[0]);
                            message.SetToBody(3, this.rack.ipAddress_short[1]);
                            message.SetToBody(4, this.rack.ipAddress_short[2]);
                            message.SetToBody(5, this.rack.ipAddress_short[3]);
                            message.SetToBody(6, this.slot);
                            message.SetToBody(7, (short)this.setting_number);
                            message.SetToBody(8, this.checking_flag);
                            message.SetToBody(9, this.lowerLim);
                            message.SetToBody(10, this.upperLim);
                            message.SetToBody(11, this.value);
                            message.SetToBody(12, this.gui_table_line_index);
                            message.SetToBody(13, card_code_byte[0]);
                            message.SetToBody(14, card_code_byte[1]);
                            message.SetToBody(15, card_code_byte[2]);
                            message.SetToBody(16, card_code_byte[3]);
                            this.rack.SendGuiObservers_Alarm(message);
                            System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                            this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                            this.AddJournalRecord(2);
                            if (this.isSendTrap <= 0) return;
                            this.rack.Send_Trap(message);
                            return;
                        }
                        if (this.is_first_time_checked) return;
                        this.is_alarm_now = false;
                        this.is_first_time_checked = true;
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)91);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, this.value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        if (this.isSendTrap <= 0) return;
                        this.rack.Send_Trap(message);
                        return;
                    }
                    if (this.is_alarm_now) return;
                    this.is_alarm_now = true;
                    if (!this.is_first_time_checked) {
                        this.is_first_time_checked = true;
                    }
                    Message message = new Message();
                    message.SetToBody(0, (short)16);
                    message.SetToBody(1, (short)90);
                    message.SetToBody(2, this.rack.ipAddress_short[0]);
                    message.SetToBody(3, this.rack.ipAddress_short[1]);
                    message.SetToBody(4, this.rack.ipAddress_short[2]);
                    message.SetToBody(5, this.rack.ipAddress_short[3]);
                    message.SetToBody(6, this.slot);
                    message.SetToBody(7, (short)this.setting_number);
                    message.SetToBody(8, this.checking_flag);
                    message.SetToBody(9, this.lowerLim);
                    message.SetToBody(10, this.upperLim);
                    message.SetToBody(11, this.value);
                    message.SetToBody(12, this.gui_table_line_index);
                    message.SetToBody(13, card_code_byte[0]);
                    message.SetToBody(14, card_code_byte[1]);
                    message.SetToBody(15, card_code_byte[2]);
                    message.SetToBody(16, card_code_byte[3]);
                    this.rack.SendGuiObservers_Alarm(message);
                    System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    this.AddJournalRecord(1);
                    if (this.isSendTrap <= 0) return;
                    this.rack.Send_Trap(message);
                    return;
                }
                short adapted_value = 0;
                if (this.setting_number == 0) {
                    short mask = (short)(this.value & 0x20);
                    if (mask > 0) {
                        return;
                    }
                    if (this.name == "INPUT") {
                        adapted_value = (short)(this.value & 2);
                        adapted_value = (short)(adapted_value >> 1);
                    }
                    if (this.name == "REF") {
                        adapted_value = (short)(this.value & 1);
                    }
                    if (this.name == "FREEZE") {
                        adapted_value = (short)(this.value & 4);
                        adapted_value = (short)(adapted_value >> 2);
                    }
                    if (this.name == "BARS") {
                        adapted_value = (short)(this.value & 8);
                        adapted_value = (short)(adapted_value >> 3);
                    }
                    adapted_value = adapted_value == 0 ? (short)2 : (short)1;
                } else if (this.setting_string.charAt(0) == '$') {
                    adapted_value = (short)(this.value & 1);
                } else {
                    short val = this.value;
                    val = (short)(val << 2);
                    adapted_value = val = (short)(val >> 2);
                }
                if (adapted_value != this.invalidValue) {
                    if (this.is_alarm_now) {
                        this.is_alarm_now = false;
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)91);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, adapted_value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.AddJournalRecord(2);
                        if (this.isSendTrap <= 0) return;
                        this.rack.Send_Trap(message);
                        return;
                    }
                    if (this.is_first_time_checked) return;
                    this.is_alarm_now = false;
                    this.is_first_time_checked = true;
                    Message message = new Message();
                    message.SetToBody(0, (short)16);
                    message.SetToBody(1, (short)91);
                    message.SetToBody(2, this.rack.ipAddress_short[0]);
                    message.SetToBody(3, this.rack.ipAddress_short[1]);
                    message.SetToBody(4, this.rack.ipAddress_short[2]);
                    message.SetToBody(5, this.rack.ipAddress_short[3]);
                    message.SetToBody(6, this.slot);
                    message.SetToBody(7, (short)this.setting_number);
                    message.SetToBody(8, this.checking_flag);
                    message.SetToBody(9, this.lowerLim);
                    message.SetToBody(10, this.upperLim);
                    message.SetToBody(11, adapted_value);
                    message.SetToBody(12, this.gui_table_line_index);
                    message.SetToBody(13, card_code_byte[0]);
                    message.SetToBody(14, card_code_byte[1]);
                    message.SetToBody(15, card_code_byte[2]);
                    message.SetToBody(16, card_code_byte[3]);
                    this.rack.SendGuiObservers_Alarm(message);
                    System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    if (this.isSendTrap <= 0) return;
                    this.rack.Send_Trap(message);
                    return;
                }
                if (this.is_alarm_now) return;
                if (!this.is_first_time_checked) {
                    this.is_first_time_checked = true;
                }
                this.is_alarm_now = true;
                Message message = new Message();
                message.SetToBody(0, (short)16);
                message.SetToBody(1, (short)90);
                message.SetToBody(2, this.rack.ipAddress_short[0]);
                message.SetToBody(3, this.rack.ipAddress_short[1]);
                message.SetToBody(4, this.rack.ipAddress_short[2]);
                message.SetToBody(5, this.rack.ipAddress_short[3]);
                message.SetToBody(6, this.slot);
                message.SetToBody(7, (short)this.setting_number);
                message.SetToBody(8, this.checking_flag);
                message.SetToBody(9, this.lowerLim);
                message.SetToBody(10, this.upperLim);
                message.SetToBody(11, adapted_value);
                message.SetToBody(12, this.gui_table_line_index);
                message.SetToBody(13, card_code_byte[0]);
                message.SetToBody(14, card_code_byte[1]);
                message.SetToBody(15, card_code_byte[2]);
                message.SetToBody(16, card_code_byte[3]);
                this.rack.SendGuiObservers_Alarm(message);
                System.out.println("ProflexSetting.CheckMonitoringParams(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                this.AddJournalRecord(1);
                if (this.isSendTrap <= 0) return;
                this.rack.Send_Trap(message);
                return;
            }
            if (this.isActive == 0 || this.file_block_code != this.card_code) {
                // empty if block
            }
            if (this.isActive != 0 || this.file_block_code == this.card_code) {
                // empty if block
            }
            if (this.isActive != 0) return;
            if (this.file_block_code == this.card_code) return;
            return;
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.CheckMonitoringParams(): " + e);
            this.dialog.AddLogRecord("ProflexSetting.CheckMonitoringParams(): " + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SendGUI_CurrentAlarmState() {
        try {
            if (this.isActive != 0 && this.file_block_code == this.card_code) {
                short[] card_code_byte = new short[]{(short)(this.file_block_code >> 24), (short)(this.file_block_code >> 16 & 0xFFL), (short)(this.file_block_code >> 8 & 0xFFL), (short)(this.file_block_code & 0xFFL)};
                if (this.checking_flag == 1) {
                    short val = this.value;
                    val = (short)(val << 2);
                    if ((val = (short)(val >> 2)) >= this.lowerLim && val <= this.upperLim) {
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)91);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, this.value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        this.rack.Send_Trap(message);
                        System.out.println("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        return;
                    } else {
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)90);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, this.value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        this.rack.Send_Trap(message);
                        System.out.println("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + this.value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    }
                    return;
                } else {
                    short adapted_value = 0;
                    if (this.setting_number == 0) {
                        short mask = (short)(this.value & 0x20);
                        if (mask > 0) {
                            return;
                        }
                        if (this.name == "INPUT") {
                            adapted_value = (short)(this.value & 2);
                            adapted_value = (short)(adapted_value >> 1);
                        }
                        if (this.name == "REF") {
                            adapted_value = (short)(this.value & 1);
                        }
                        if (this.name == "FREEZE") {
                            adapted_value = (short)(this.value & 4);
                            adapted_value = (short)(adapted_value >> 2);
                        }
                        if (this.name == "BARS") {
                            adapted_value = (short)(this.value & 8);
                            adapted_value = (short)(adapted_value >> 3);
                        }
                        adapted_value = adapted_value == 0 ? (short)2 : (short)1;
                    } else if (this.setting_string.charAt(0) == '$') {
                        adapted_value = (short)(this.value & 1);
                    } else {
                        short val = this.value;
                        val = (short)(val << 2);
                        adapted_value = val = (short)(val >> 2);
                    }
                    if (adapted_value != this.invalidValue) {
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)91);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, adapted_value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        this.rack.Send_Trap(message);
                        System.out.println("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM OFF: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        return;
                    } else {
                        Message message = new Message();
                        message.SetToBody(0, (short)16);
                        message.SetToBody(1, (short)90);
                        message.SetToBody(2, this.rack.ipAddress_short[0]);
                        message.SetToBody(3, this.rack.ipAddress_short[1]);
                        message.SetToBody(4, this.rack.ipAddress_short[2]);
                        message.SetToBody(5, this.rack.ipAddress_short[3]);
                        message.SetToBody(6, this.slot);
                        message.SetToBody(7, (short)this.setting_number);
                        message.SetToBody(8, this.checking_flag);
                        message.SetToBody(9, this.lowerLim);
                        message.SetToBody(10, this.upperLim);
                        message.SetToBody(11, adapted_value);
                        message.SetToBody(12, this.gui_table_line_index);
                        message.SetToBody(13, card_code_byte[0]);
                        message.SetToBody(14, card_code_byte[1]);
                        message.SetToBody(15, card_code_byte[2]);
                        message.SetToBody(16, card_code_byte[3]);
                        this.rack.SendGuiObservers_Alarm(message);
                        this.rack.Send_Trap(message);
                        System.out.println("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                        this.dialog.AddLogRecord("ProflexSetting.SendGUI_CurrentAlarmState(): ALARM ON: IP = " + this.ip_string + ", " + "slot = " + this.slot + ", " + "card_code = " + this.file_block_code + ", " + "setting_num = " + this.setting_number + ", " + "current_value = " + adapted_value + "  (" + "checking_flag = " + this.checking_flag + ", " + "lower_lim = " + this.lowerLim + ", " + "upper_lim = " + this.upperLim + ", " + "invalid_val = " + this.invalidValue + ", " + "is_active = " + this.isActive + ", " + "b_send_trap = " + this.isSendTrap + ", " + "gui_table_line_index = " + this.gui_table_line_index + ")");
                    }
                }
                return;
            }
            if (this.isActive == 0 || this.file_block_code != this.card_code) {
                // empty if block
            }
            if (this.isActive != 0 || this.file_block_code == this.card_code) {
                // empty if block
            }
            if (this.isActive == 0 && this.file_block_code == this.card_code) return;
        }
        catch (Exception e) {
            System.out.println("ProflexSetting.SendGUI_CurrentAlarmState(): " + e);
            this.dialog.AddLogRecord("ProflexSetting.SendGUI_CurrentAlarmState(): " + e);
        }
    }

    public short getLower_lim() {
        return this.lowerLim;
    }

    public void setLower_lim(short lower_lim) {
        this.lowerLim = lower_lim;
    }

    public short getUpper_lim() {
        return this.upperLim;
    }

    public void setUpper_lim(short upper_lim) {
        this.upperLim = upper_lim;
    }

    public short isbSendTrap() {
        return this.isSendTrap;
    }

    public void setbSendTrap(short isSendTrap) {
        this.isSendTrap = isSendTrap;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        short sign_bit;
        if (this.ip_string.equals("192.168.2.225") && this.slot == 13 && this.setting_number == 23) {
            boolean kkk = false;
        }
        if ((sign_bit = (short)(value & 0x4000)) != 0) {
            this.value = (short)((~value & 0x3FFF) + 1);
            this.value = (short)(this.value * -1);
        } else {
            this.value = value;
        }
    }
}

