/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.snmp4j.smi.IpAddress;

public class Socket_TCP
extends CoreSocket {
    MainDialog dialog;
    private static Socket_TCP instance;
    private int port = 0;
    private ServerSocket socket;
    private ConnectionThread connectionThread;
    private ArrayList<IpAddress> resolved_gui_list = new ArrayList();
    private ArrayList<ObserverObject> observerObjects = new ArrayList();
    private ArrayList<Connection> connections = new ArrayList();
    private String DEFAULT_JOURNAL_FILENAME = "socket_tcp.txt";

    private synchronized void AddConnection(Connection connection) {
        try {
            this.connections.add(connection);
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.AddConnection(): " + e);
            this.dialog.AddLogRecord("Socket_TCP.AddConnection(): " + e);
        }
    }

    public static Socket_TCP getInstance() {
        if (instance == null) {
            instance = new Socket_TCP();
        }
        return instance;
    }

    private Socket_TCP() {
        try {
            this.resolved_gui_list.clear();
            this.message_in = new Message();
            this.message_out = new Message();
            this.settings.add(new CoreSetting("resolved_gui_list"));
            this.settings.add(new CoreSetting("gui_port"));
            this.GetObjectConfig();
            String ip_string = ((CoreSetting)this.settings.get(0)).getValue();
            String[] ip_string_list = ip_string.split(",");
            int i = 0;
            for (i = 0; i < ip_string_list.length; ++i) {
                this.resolved_gui_list.add(new IpAddress(ip_string_list[i]));
            }
            this.port = Integer.valueOf(((CoreSetting)this.settings.get(1)).getValue());
            this.socket = new ServerSocket(this.port);
            this.socket.setReuseAddress(true);
        }
        catch (Exception e) {
            System.out.println("Socket_TCP() : " + e);
        }
    }

    @Override
    public void Start() {
        try {
            System.out.println("Starting Socket_TCP...");
            this.setDaemon(true);
            this.setPriority(6);
            this.start();
            this.connectionThread = new ConnectionThread();
        }
        catch (Exception e) {
            this.dialog.AddLogRecord("Socket_TCP.Start() : " + e);
            System.out.println("Socket_TCP.Start() : " + e);
        }
    }

    @Override
    public void Stop() {
        this.connectionThread.Stop();
    }

    @Override
    public synchronized void Read() {
        ArrayList<Connection> connections_tmp = new ArrayList<Connection>();
        try {
            for (Connection connection : this.connections) {
                try {
                    int ridden;
                    byte[] buf;
                    block13: {
                        if (connection.getSocket().isClosed()) continue;
                        buf = new byte[262144];
                        ridden = 0;
                        try {
                            InputStream is = connection.getSocket().getInputStream();
                            ridden = is.read(buf);
                            if (ridden != -1) break block13;
                            String connection_info = connection.getSocket().getInetAddress().getHostAddress() + ":" + connection.getSocket().getPort();
                            String connection_str_full = "Socket_TCP->Read() closing connection: " + connection_info;
                            System.out.println(connection_str_full);
                            this.dialog.AddLogRecord(connection_str_full);
                            this.CloseConnection(connection);
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("Socket_TCP.Read() -> readind block : " + e);
                            this.dialog.AddLogRecord("Socket_TCP.Read() -> reading block : " + e);
                            this.CloseConnection(connection);
                        }
                    }
                    if (ridden <= 0) continue;
                    String client_info = connection.getSocket().getInetAddress().getHostAddress() + ":" + connection.getSocket().getPort();
                    String str_full = "Message from GUI  (IP = " + client_info + "); ";
                    connections_tmp.add(connection);
                    Message message = new Message();
                    message.ZeroMessage();
                    short[] short_buf = new short[131072];
                    this.ConvertByteToShortBuffer_new(buf, short_buf);
                    int i = 0;
                    byte[] ip_sh = connection.getSocket().getInetAddress().getAddress();
                    int pos = 0;
                    short command_length = short_buf[pos];
                    while (command_length > 0) {
                        message.ZeroMessage();
                        this.message_in.getClass();
                        this.message_in.getClass();
                        message.SetToHeader(1, (short)1);
                        this.message_in.getClass();
                        message.SetToHeader(2, (short)(0xFF & (short)ip_sh[0]));
                        this.message_in.getClass();
                        message.SetToHeader(3, (short)(0xFF & (short)ip_sh[1]));
                        message.SetToHeader(this.message_in.POS_MESSAGE_IP3, (short)(0xFF & (short)ip_sh[2]));
                        message.SetToHeader(this.message_in.POS_MESSAGE_IP4, (short)(0xFF & (short)ip_sh[3]));
                        message.SetToHeader(this.message_in.POS_SIZE_OF_DATA, (short)(command_length + 1));
                        for (i = 0; i < command_length + 1; ++i) {
                            message.SetToBody(i, short_buf[pos + i]);
                        }
                        if (message.GetFromBody(1) == 130) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss:SSS");
                            Date date = new Date();
                            String date_str = sdf.format(date);
                            String full_str = "Socket_TCP->Read(): ( " + date_str + " ), NETWORK PULSE FROM [ " + connection.getSocket().getInetAddress() + " ]";
                        }
                        this.NotifyObservers(message);
                        pos = (short)(pos + command_length + 1);
                        command_length = short_buf[pos];
                    }
                }
                catch (Exception e) {
                    System.out.println("Socket_TCP.Read() -> connection reading : " + e);
                    this.dialog.AddLogRecord("Socket_TCP.Read() -> connection reading : " + e);
                    this.CloseConnection(connection);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.Read() -> Connection iterator : " + e);
            this.dialog.AddLogRecord("Socket_TCP.Read() -> Connection iterator : " + e);
        }
        try {
            this.connections.clear();
            for (Connection conn : connections_tmp) {
                this.connections.add(conn);
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.Read() -> Connections list refilling : " + e);
            this.dialog.AddLogRecord("Socket_TCP.Read() -> Connections list refilling : " + e);
        }
    }

    @Override
    public void Write() {
    }

    public void Write(Message message) {
        block8: {
            try {
                if (this.socket.isClosed()) break block8;
                for (Connection connection : this.connections) {
                    byte[] dest_ip;
                    byte[] connection_ip = connection.getSocket().getInetAddress().getAddress();
                    if (!Arrays.equals(connection_ip, dest_ip = message.getIP_IpAddress().toByteArray())) continue;
                    OutputStream os = connection.socket.getOutputStream();
                    String client_info = connection.socket.getInetAddress().getHostAddress() + ":" + connection.socket.getPort();
                    String str_full = "Message to client  (IP = " + client_info + "); ";
                    int buffer_length = message.GetFromBody(0);
                    byte[] buf = new byte[(buffer_length + 1) * 2];
                    short[] sh_buf = new short[buffer_length + 1];
                    if (message.GetFromBody(1) == 130) {
                        boolean yyyy = false;
                    }
                    for (int i = 0; i <= buffer_length; ++i) {
                        sh_buf[i] = message.GetFromBody(i);
                    }
                    this.ConvertShortToByteBuffer_new(sh_buf, buf);
                    try {
                        if (message.GetFromBody(1) != 400) {
                            os.write(buf, 0, buf.length);
                            os.flush();
                        }
                    }
                    catch (Exception e) {
                        this.dialog.AddLogRecord("Socket_TCP->Write() os.write : " + e);
                        System.out.println("Socket_TCP->Write() os.write : " + e);
                        this.CloseConnection(connection);
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.dialog.AddLogRecord("Socket_TCP->Write() : " + e);
                System.out.println("Socket_TCP->Write() : " + e);
            }
        }
    }

    public void CloseConnection(Connection connection) {
        try {
            String client_info = connection.getSocket().getInetAddress().getHostAddress() + ":" + connection.getSocket().getPort();
            String str_full = "Socket_TCP.CloseConnection(): GUI disconnected (IP = " + client_info + "); ";
            this.dialog.AddLogRecord(str_full);
            System.out.println(str_full);
            connection.getSocket().close();
            this.message_in.ZeroMessage();
            boolean i = false;
            byte[] ip_sh = connection.getSocket().getInetAddress().getAddress();
            int port = connection.getSocket().getPort();
            this.message_in.getClass();
            this.message_in.getClass();
            this.message_in.SetToHeader(1, (short)3);
            this.message_in.getClass();
            this.message_in.SetToHeader(2, (short)(0xFF & (short)ip_sh[0]));
            this.message_in.getClass();
            this.message_in.SetToHeader(3, (short)(0xFF & (short)ip_sh[1]));
            this.message_in.SetToHeader(this.message_in.POS_MESSAGE_IP3, (short)(0xFF & (short)ip_sh[2]));
            this.message_in.SetToHeader(this.message_in.POS_MESSAGE_IP4, (short)(0xFF & (short)ip_sh[3]));
            this.NotifyObservers(this.message_in);
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.CloseConnection() : " + e);
        }
    }

    public void CloseConnectionByTimeout(String ip) {
        try {
            for (Connection connection : this.connections) {
                if (!ip.equals(connection.getSocket().getInetAddress().getHostAddress())) continue;
                String client_info = connection.getSocket().getInetAddress().getHostAddress() + ":" + connection.getSocket().getPort();
                String str_full = "Socket_TCP.CloseConnectionByTimeout(): GUI disconnected (IP = " + client_info + "); ";
                this.dialog.AddLogRecord(str_full);
                System.out.println(str_full);
                connection.getSocket().close();
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.CloseConnectionByTimeout() : " + e);
        }
    }

    @Override
    public void AddObserver(ObserverObject observer) {
        try {
            this.observerObjects.add(observer);
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.AddObserver() : " + e);
        }
    }

    @Override
    public void RemoveObserver(ObserverObject observer) {
        try {
            this.observerObjects.remove(observer);
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.RemoveObserver() : " + e);
        }
    }

    @Override
    public void NotifyObservers() {
        try {
            boolean i = false;
            for (ObserverObject object : this.observerObjects) {
                if (object == null) continue;
                object.ProcessEvent();
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.NotifyObservers() : " + e);
        }
    }

    @Override
    public void NotifyObservers(String str) {
        try {
            boolean i = false;
            for (ObserverObject object : this.observerObjects) {
                if (object == null) continue;
                object.ProcessEvent(str);
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.NotifyObservers() : " + e);
        }
    }

    @Override
    public void NotifyObservers(Message message) {
        try {
            for (ObserverObject object : this.observerObjects) {
                if (object == null) continue;
                object.ProcessEvent(message);
            }
        }
        catch (Exception e) {
            System.out.println("Socket_TCP.NotifyObservers() : " + e);
        }
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                Socket_TCP.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.Read();
        }
    }

    public void Write_File(byte[] buf) {
    }

    private class ConnectionThread
    extends Thread {
        private boolean is_running;

        public ConnectionThread() {
            try {
                this.is_running = true;
                System.out.println("Socket_TCP.ConnectionThread started...");
                this.setDaemon(true);
                this.setPriority(3);
                this.start();
            }
            catch (Exception e) {
                System.out.println("Socket_TCP.ConnectionThread() : " + e);
            }
        }

        @Override
        public void run() {
            while (this.is_running) {
                try {
                    String connection_str_full;
                    String connection_info;
                    Socket s = Socket_TCP.this.socket.accept();
                    boolean b_found = false;
                    boolean b_multiple_connection = false;
                    for (Connection connection : Socket_TCP.this.connections) {
                        String existing_addr;
                        String new_addr = s.getInetAddress().getHostAddress();
                        if (!new_addr.equals(existing_addr = connection.getSocket().getInetAddress().getHostAddress())) continue;
                        b_multiple_connection = true;
                        s.close();
                        break;
                    }
                    if (!b_multiple_connection) {
                        connection_info = s.getInetAddress().getHostAddress() + ":" + s.getPort();
                        connection_str_full = "Socket_TCP: Connection accepted (IP = " + connection_info + "); ";
                        System.out.println(connection_str_full);
                        Socket_TCP.this.dialog.AddLogRecord(connection_str_full);
                        for (IpAddress ipAddress : Socket_TCP.this.resolved_gui_list) {
                            String ip_conn;
                            String ip_res = ipAddress.toString();
                            if (!ip_res.equals(ip_conn = s.getInetAddress().getHostAddress())) continue;
                            Socket_TCP.this.AddConnection(new Connection(s));
                            connection_str_full = "Socket_TCP: Connections list = ";
                            for (Connection connection : Socket_TCP.this.connections) {
                                connection_info = connection.getSocket().getInetAddress().getHostAddress() + ":" + connection.getSocket().getPort();
                                connection_str_full = connection_str_full + connection_info;
                                connection_str_full = connection_str_full + ", ";
                            }
                            System.out.println(connection_str_full);
                            Socket_TCP.this.dialog.AddLogRecord(connection_str_full);
                            String gui_info = s.getInetAddress().getHostAddress() + ":" + s.getPort();
                            String str_full = "GUI connected (IP = " + gui_info + "); ";
                            System.out.println(str_full);
                            b_found = true;
                            break;
                        }
                        if (b_found) continue;
                        String gui_info = s.getInetAddress().getHostAddress() + ":" + s.getPort();
                        String str_full = "Socket_TCP: Connection refused (IP = " + gui_info + "); ";
                        System.out.println(str_full);
                        Socket_TCP.this.dialog.AddLogRecord(str_full);
                        s.close();
                        continue;
                    }
                    connection_info = s.getInetAddress().getHostAddress() + ":" + s.getPort();
                    connection_str_full = "Socket_TCP: GUI multiple connection request. Connection refused. (IP = " + connection_info + "); ";
                    System.out.println(connection_str_full);
                    Socket_TCP.this.dialog.AddLogRecord(connection_str_full);
                }
                catch (Exception exception) {}
            }
        }

        public void Stop() {
            this.is_running = false;
        }
    }
}

