/*
 * Decompiled with CFR 0.152.
 */
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.snmp4j.smi.IpAddress;

public class Socket_UDP
extends CoreSocket {
    private static Socket_UDP instance;
    private int port = 0;
    private DatagramSocket socket;
    Decoder5566 decoder5566 = new Decoder5566();
    private ArrayList<IpAddress> resolved_rack_list = new ArrayList();
    private ArrayList<ObserverObject> observerObjects = new ArrayList();
    private ArrayList<Connection> connections = new ArrayList();

    public Socket_UDP() {
        try {
            this.resolved_rack_list.clear();
            this.message_in = new Message();
            this.message_out = new Message();
            this.settings.add(new CoreSetting("resolved_rack_list"));
            this.settings.add(new CoreSetting("rack_port"));
            this.GetObjectConfig();
            String ip_string = ((CoreSetting)this.settings.get(0)).getValue();
            String[] ip_string_list = ip_string.split(",");
            int i = 0;
            for (i = 0; i < ip_string_list.length; ++i) {
                this.resolved_rack_list.add(new IpAddress(ip_string_list[i]));
            }
            this.port = Integer.valueOf(((CoreSetting)this.settings.get(1)).getValue());
            try {
                this.socket = new DatagramSocket(null);
                this.socket.setReuseAddress(true);
                this.socket.bind(new InetSocketAddress(this.port));
            }
            catch (Exception es) {
                System.out.println("Socket_UDP() creation : " + es);
            }
        }
        catch (Exception e) {
            System.out.println("Socket_UDP() : " + e);
        }
    }

    public static synchronized Socket_UDP getInstance() {
        if (instance == null) {
            instance = new Socket_UDP();
        }
        return instance;
    }

    @Override
    public void Start() {
        try {
            System.out.println("Starting Socket_UDP...");
            this.setDaemon(true);
            this.setPriority(6);
            this.start();
        }
        catch (Exception e) {
            System.out.println("Socket_UDP.Start() : " + e);
        }
    }

    @Override
    public void Stop() {
    }

    @Override
    public void Read() {
        try {
            byte[] buf = new byte[8192];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            this.socket.receive(packet);
            InetAddress packet_ip = packet.getAddress();
            int port = packet.getPort();
            boolean i = false;
            for (IpAddress resolved_rack_ip : this.resolved_rack_list) {
                byte[] sender_ip;
                byte[] res_ip = resolved_rack_ip.toByteArray();
                if (!Arrays.equals(res_ip, sender_ip = packet_ip.getAddress())) continue;
                int k = 0;
                int n = 0;
                int begin = 0;
                int end = 0;
                boolean bfound = false;
                int messages_count = 0;
                block3: for (k = 0; k < buf.length - 1; ++k) {
                    if (buf[k] != 5 || buf[k + 1] != 5) continue;
                    begin = k;
                    for (n = k + 2; n < buf.length - 1; ++n) {
                        if (buf[n] != 6 || buf[n + 1] != 6) continue;
                        end = n + 1;
                        bfound = true;
                        Message message = new Message();
                        message.getClass();
                        message.SetToHeader(1, (short)2);
                        message.getClass();
                        message.SetToHeader(2, (short)(0xFF & (short)sender_ip[0]));
                        message.getClass();
                        message.SetToHeader(3, (short)(0xFF & (short)sender_ip[1]));
                        message.SetToHeader(message.POS_MESSAGE_IP3, (short)(0xFF & (short)sender_ip[2]));
                        message.SetToHeader(message.POS_MESSAGE_IP4, (short)(0xFF & (short)sender_ip[3]));
                        message.SetToHeader(message.POS_MESSAGE_PORT, (short)port);
                        message.SetToHeader(message.POS_SIZE_OF_DATA, (short)(end - begin));
                        for (k = begin; k <= end; ++k) {
                            message.SetToBody(k - begin, (short)(0xFF & (short)buf[k]));
                        }
                        this.decoder5566.Decode5566(message);
                        this.NotifyObservers(message);
                        k = end;
                        ++messages_count;
                        continue block3;
                    }
                }
                if (messages_count <= true) continue;
                boolean pppp = false;
            }
        }
        catch (Exception e) {
            System.out.println("Socket_UDP.Read() : " + e);
        }
    }

    @Override
    public void Write() {
    }

    public void Write(Message message) {
        try {
            int i = 0;
            short[] sh_buf = new short[4096];
            byte[] buf = new byte[8192];
            byte[] ip = message.getIP_byte();
            InetAddress inetAddress = InetAddress.getByAddress(ip);
            if (message.GetFromBody(3) == 5) {
                boolean hhhhh = false;
            }
            this.decoder5566.Encode5566(message);
            for (i = 0; i < message.GetFromHeader(message.POS_SIZE_OF_DATA); ++i) {
                buf[i] = (byte)message.GetFromBody(i);
            }
            DatagramPacket packet = new DatagramPacket(buf, (int)message.GetFromHeader(message.POS_SIZE_OF_DATA), inetAddress, 10001);
            this.socket.send(packet);
        }
        catch (Exception e) {
            System.out.println("Socket_UDP()->Write() : " + e);
        }
    }

    @Override
    public void AddObserver(ObserverObject observer) {
        try {
            this.observerObjects.add(observer);
        }
        catch (Exception e) {
            System.out.println("Socket_UDP.AddObserver() : " + e);
        }
    }

    @Override
    public void RemoveObserver(ObserverObject observer) {
        try {
            this.observerObjects.remove(observer);
        }
        catch (Exception e) {
            System.out.println("Socket_UDP.RemoveObserver() : " + e);
        }
    }

    @Override
    public void NotifyObservers() {
    }

    @Override
    public void NotifyObservers(String str) {
    }

    @Override
    public void NotifyObservers(Message message) {
        try {
            for (ObserverObject object : this.observerObjects) {
                if (object == null) continue;
                object.ProcessEvent(message);
            }
        }
        catch (Exception e) {
            System.out.println("Socket_UDP.NotifyObservers() : " + e);
        }
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                Socket_UDP.sleep(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.Read();
        }
    }
}

