/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapSocket
extends Thread {
    private Snmp snmp = null;
    MainDialog dialog;
    String str_addr = this.GetSetting_HostAddress();
    private Address targetAddress = GenericAddress.parse(this.str_addr);
    String str_dest_addr = this.GetSetting_DestAddress();
    public Address destAddress = GenericAddress.parse(this.str_dest_addr);
    String enterprise_oid = this.GetSetting_EnterpriseOID();
    private TransportMapping transport = null;

    public TrapSocket(MainDialog dialog) throws Exception {
        this.dialog = dialog;
        this.transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        CommandResponder trapPrinter = new CommandResponder(){

            @Override
            public synchronized void processPdu(CommandResponderEvent e) {
                try {
                    PDU command = e.getPDU();
                    String sss = e.toString();
                    UdpAddress udpHostAddress = (UdpAddress)e.getStateReference().getAddress();
                    String nfo_1 = udpHostAddress.toString();
                    String nfo_2 = udpHostAddress.getInetAddress().getHostAddress().toString();
                    if (command != null) {
                        System.out.println("SNMP Trap received: " + command.toString());
                        System.out.println("SNMP Trap received: " + nfo_1);
                        System.out.println("SNMP Trap received: " + nfo_2);
                    }
                }
                catch (Exception e1) {
                    System.out.println("SNMP Trap received: INVALID TRAP v2");
                }
            }
        };
        this.snmp.addNotificationListener(this.targetAddress, trapPrinter);
    }

    public String GetSetting_HostAddress() {
        try {
            String s;
            FileReader fr = new FileReader("core_config.conf");
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null && s.length() > 0) {
                int i = 0;
                int pos = 0;
                for (i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch != '=') continue;
                    pos = i;
                    break;
                }
                String setting_name = s.substring(0, pos);
                String setting_value = s.substring(pos + 2, s.length());
                if (!setting_name.equals("trap_host ")) continue;
                return setting_value;
            }
            fr.close();
        }
        catch (Exception e) {
            System.out.println("TrapSocket: GetSetting_HostAddress(): " + e);
            this.dialog.AddLogRecord("TrapSocket: GetSetting_HostAddress(): " + e);
        }
        return null;
    }

    public String GetSetting_EnterpriseOID() {
        try {
            String s;
            FileReader fr = new FileReader("core_config.conf");
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null && s.length() > 0) {
                int i = 0;
                int pos = 0;
                for (i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch != '=') continue;
                    pos = i;
                    break;
                }
                String setting_name = s.substring(0, pos);
                String setting_value = s.substring(pos + 2, s.length());
                if (!setting_name.equals("enterprise_oid ")) continue;
                return setting_value;
            }
            fr.close();
        }
        catch (Exception e) {
            System.out.println("TrapSocket: GetSetting_EnterpriseOID(): " + e);
            this.dialog.AddLogRecord("TrapSocket: GetSetting_EnterpriseOID(): " + e);
        }
        return null;
    }

    public String GetSetting_DestAddress() {
        try {
            String s;
            FileReader fr = new FileReader("core_config.conf");
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null && s.length() > 0) {
                int i = 0;
                int pos = 0;
                for (i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch != '=') continue;
                    pos = i;
                    break;
                }
                String setting_name = s.substring(0, pos);
                String setting_value = s.substring(pos + 2, s.length());
                if (!setting_name.equals("trap_dest ")) continue;
                return setting_value;
            }
            fr.close();
        }
        catch (Exception e) {
            System.out.println("TrapSocket: GetSetting_DestAddress(): " + e);
            this.dialog.AddLogRecord("TrapSocket: GetSetting_DestAddress(): " + e);
        }
        return null;
    }

    public void send() {
        CommunityTarget c_target = new CommunityTarget();
        c_target.setCommunity(new OctetString("public"));
        c_target.setAddress(this.destAddress);
        c_target.setVersion(0);
        PDU pdu = new PDU();
        OID sender_oid = new OID("1.2.3.4.111");
        pdu.setType(-90);
        pdu.addOID(new VariableBinding(new OID(".1.3.6.1.4.1.27500.2.100.1")));
        String community = "public";
        String Oid = ".1.3.6.1.4.1.27500.2.100";
        String ipAddress = "192.168.2.29";
        PDUv1 pdu_1 = new PDUv1();
        pdu_1.setType(-92);
        pdu_1.setEnterprise(new OID(Oid));
        pdu_1.setGenericTrap(6);
        pdu_1.setSpecificTrap(1);
        pdu_1.setAgentAddress(new IpAddress(ipAddress));
        VariableBinding vb_1 = new VariableBinding(new OID(".1.3.6.1.4.1.27500.2.100.1"), new OctetString("some_var"));
        pdu_1.add(vb_1);
        try {
            this.snmp.send(pdu, c_target, this.transport);
            System.out.println("SNMP Trap sent v2c: " + pdu.toString());
            this.dialog.AddLogRecord("SNMP Trap v2csent:" + pdu.toString());
            this.snmp.send(pdu_1, c_target, this.transport);
            System.out.println("SNMP Trap sent v1: " + pdu_1.toString());
            this.dialog.AddLogRecord("SNMP Trap sent v1:" + pdu_1.toString());
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public void SendTrap(int[] data) {
        CommunityTarget c_target = new CommunityTarget();
        c_target.setCommunity(new OctetString("public"));
        c_target.setAddress(this.destAddress);
        c_target.setVersion(0);
        PDUv1 pdu = new PDUv1();
        pdu.setType(-92);
        pdu.setEnterprise(new OID(this.enterprise_oid));
        pdu.setGenericTrap(6);
        pdu.setSpecificTrap(1);
        int i = 0;
        byte[] ip = new byte[4];
        for (i = 0; i < 4; ++i) {
            ip[i] = (byte)data[i];
        }
        pdu.setAgentAddress(new IpAddress(ip));
        OID oid_full = new OID(this.enterprise_oid);
        oid_full.append(1);
        oid_full.append(data[4]);
        oid_full.append(data[5]);
        oid_full.append(data[6]);
        oid_full.append(data[7]);
        oid_full.append(data[8]);
        String data_str = "Switch " + this.enterprise_oid + String.valueOf(data[4]) + "." + String.valueOf(data[5]) + "." + String.valueOf(data[6]) + "." + String.valueOf(data[7]) + "." + String.valueOf(data[8]);
        String value = String.valueOf(data[9]);
        VariableBinding vb_1 = new VariableBinding(new OID(this.enterprise_oid), new OctetString(data_str));
        pdu.add(vb_1);
        try {
            this.snmp.send(pdu, c_target, this.transport);
            System.out.println("SNMP Trap sent: " + pdu.toString());
            this.dialog.AddLogRecord("SNMP Trap sent:" + pdu.toString());
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public void Start() throws Exception {
        this.setPriority(3);
        this.start();
        this.send();
        System.out.println(0);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    TrapSocket.sleep(1000000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

